/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.util;

import com.petalslink.easiersbs.matching.service.api.matcher.DegreeOfMatch;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredConcept;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredElement;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.RatedURI;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticElement;
import com.petalslink.easiersbs.matching.service.profile.inferred.RatedURIImpl;
import com.petalslink.easiersbs.matching.service.profile.rated.RatedSemanticElementImpl;
import com.petalslink.easiersbs.matching.service.util.VectorUtil;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericPart;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class SimilarityUtil {
    public static List<String> extractElementRelatedWords(Set<? extends GenericPart> parts) {
        ArrayList<String> res = new ArrayList<String>();
        for (GenericPart genericPart : parts) {
            if (genericPart.getName() != null) {
                res.addAll(SimilarityUtil.splitInWords(genericPart.getName()));
            }
            if (genericPart.getSemanticConcepts().isEmpty()) continue;
            res.addAll(SimilarityUtil.extractUriRelatedWords(genericPart.getSemanticConcepts()));
        }
        return res;
    }

    public static List<String> extractUriRelatedWords(Set<URI> uris) {
        ArrayList<String> res = new ArrayList<String>();
        for (URI uri : uris) {
            String frag = uri.getFragment();
            if (frag == null) continue;
            res.addAll(SimilarityUtil.splitInWords(frag));
        }
        return res;
    }

    public static List<String> splitInWords(String txt) {
        ArrayList<String> res = new ArrayList<String>();
        for (String s : txt.split("(?=[A-Z][a-z]+)|[-_0-9\\s]")) {
            if (s.isEmpty()) continue;
            res.add(s.toLowerCase());
        }
        return res;
    }

    public static double measureSemanticSimilarity(Set<InferredConcept> inferedConcepts, Set<URI> targetConcepts) {
        double res = 0.0;
        if (!inferedConcepts.isEmpty() && !targetConcepts.isEmpty()) {
            double sum = 0.0;
            for (InferredConcept inferedConcept : inferedConcepts) {
                Set ratedConcepts = inferedConcept.getRatedSemanticConcepts();
                double conceptRate = 0.0;
                block1: for (URI targetConceptUri : targetConcepts) {
                    RatedURIImpl serviceConcept = new RatedURIImpl(targetConceptUri);
                    if (!ratedConcepts.contains(serviceConcept)) continue;
                    for (RatedURI uri : ratedConcepts) {
                        if (!uri.equals(serviceConcept)) continue;
                        conceptRate = Math.max(conceptRate, uri.getRate());
                        continue block1;
                    }
                }
                sum += conceptRate;
            }
            res = sum / (double)inferedConcepts.size();
        }
        return res;
    }

    public static RatedSemanticElement measureElementSimilarity(InferredElement infElement, SemanticElement targetElement, double subsumeMark, double pluginMark) {
        RatedSemanticElementImpl res = new RatedSemanticElementImpl();
        if (infElement != null && targetElement != null) {
            HashMap<SemanticElement, Double> pluginMap = new HashMap<SemanticElement, Double>();
            for (SemanticElement element : ServiceUtil.getFlattenElements((GenericElement)targetElement)) {
                pluginMap.put(element, 0.0);
            }
            HashMap<InferredElement, Double> subsumeMap = new HashMap<InferredElement, Double>();
            for (InferredElement element : ServiceUtil.getFlattenElements((GenericElement)infElement)) {
                subsumeMap.put(element, 0.0);
            }
            HashSet<InferredElement> hierarchy = new HashSet<InferredElement>();
            hierarchy.add(infElement);
            double rate = SimilarityUtil.measureElementSimilarity(infElement, targetElement, pluginMap, subsumeMap, hierarchy);
            double penalty = 1.0;
            if (rate == 0.0) {
                res.setCoverage(DegreeOfMatch.FAIL);
            } else {
                if (!SimilarityUtil.isCoverageAcceptable(targetElement, pluginMap)) {
                    res.setCoverage(DegreeOfMatch.PLUGIN);
                    penalty = pluginMark;
                }
                if (!SimilarityUtil.isCoverageAcceptable(infElement, subsumeMap)) {
                    if (res.getCoverage() != DegreeOfMatch.PLUGIN) {
                        res.setCoverage(DegreeOfMatch.SUBSUMES);
                    } else {
                        res.setCoverage(DegreeOfMatch.PLUGIN_SUBSUMES);
                    }
                    penalty *= subsumeMark;
                }
                if (penalty == 1.0) {
                    res.setCoverage(DegreeOfMatch.EXACT);
                }
            }
            res.setRate(rate * penalty);
        }
        return res;
    }

    private static double measureElementSimilarity(InferredElement infElement, SemanticElement targetElement, Map<SemanticElement, Double> pluginMap, Map<InferredElement, Double> subsumeMap, Set<InferredElement> hierarchy) {
        double semanticRate = 0.0;
        SemanticElement bestTarget = null;
        for (SemanticElement target : ServiceUtil.getFlattenElements((GenericElement)targetElement)) {
            double targetRate = SimilarityUtil.measureSemanticSimilarity(infElement.getInferedSemanticConcepts(), target.getSemanticConcepts());
            if (!(targetRate > semanticRate)) continue;
            bestTarget = target;
            semanticRate = targetRate;
        }
        if (bestTarget != null) {
            pluginMap.put(bestTarget, semanticRate);
            subsumeMap.put(infElement, semanticRate);
        }
        double childrenRate = 0.0;
        if (infElement.hasChildElement() && semanticRate != 1.0) {
            Double[] childRates = new Double[infElement.getChildElements().size()];
            int i = 0;
            for (InferredElement infChild : infElement.getChildElements()) {
                if (subsumeMap.get(infChild) != 0.0 || hierarchy.contains(infChild)) {
                    childRates[i++] = subsumeMap.get(infChild);
                    continue;
                }
                hierarchy.add(infChild);
                childRates[i++] = SimilarityUtil.measureElementSimilarity(infChild, targetElement, pluginMap, subsumeMap, hierarchy);
                hierarchy.remove(infChild);
            }
            childrenRate = VectorUtil.average(childRates);
        }
        return Math.max(semanticRate, childrenRate);
    }

    private static <E extends GenericElement<E>> boolean isCoverageAcceptable(E element, Map<E, Double> coverageMap) {
        return SimilarityUtil.isCoverageAcceptable(element, coverageMap, new HashSet());
    }

    private static <E extends GenericElement<E>> boolean isCoverageAcceptable(E element, Map<E, Double> coverageMap, Set<E> elementList) {
        if (coverageMap.get(element) != 0.0) {
            return true;
        }
        if (element.hasChildElement() && !elementList.contains(element)) {
            elementList.add(element);
            for (GenericElement child : element.getChildElements()) {
                if (SimilarityUtil.isCoverageAcceptable(child, coverageMap, elementList)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Map<QName, QName> findElementMatchings(InferredElement elem1, SemanticElement elem2) {
        return SimilarityUtil.findElementMatchings(elem1, elem2, new HashSet<QName>());
    }

    private static Map<QName, QName> findElementMatchings(InferredElement elem1, SemanticElement elem2, Set<QName> elementList) {
        HashMap<QName, QName> res = new HashMap<QName, QName>();
        RatedSemanticElement result = SimilarityUtil.measureElementSimilarity(elem1, elem2, 0.5, 0.5);
        elementList.add(elem1.getElementQName());
        elementList.add(elem2.getElementQName());
        if (result.getCoverage().equals((Object)DegreeOfMatch.FAIL)) {
            return res;
        }
        if (result.getCoverage().equals((Object)DegreeOfMatch.EXACT)) {
            res.put(elem1.getElementQName(), elem2.getElementQName());
        } else {
            if (result.getCoverage().equals((Object)DegreeOfMatch.SUBSUMES) || result.getCoverage().equals((Object)DegreeOfMatch.PLUGIN_SUBSUMES)) {
                for (InferredElement child : elem1.getChildElements()) {
                    if (elementList.contains(child.getElementQName())) continue;
                    res.putAll(SimilarityUtil.findElementMatchings(child, elem2, elementList));
                }
            }
            if (result.getCoverage().equals((Object)DegreeOfMatch.PLUGIN) || result.getCoverage().equals((Object)DegreeOfMatch.PLUGIN_SUBSUMES)) {
                for (InferredElement child : elem2.getChildElements()) {
                    if (elementList.contains(child.getElementQName())) continue;
                    res.putAll(SimilarityUtil.findElementMatchings(elem1, (SemanticElement)child, elementList));
                }
            }
        }
        return res;
    }
}

