/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.SBSFactoryImpl;
import com.petalslink.easiersbs.matching.service.api.EasierSBSException;
import com.petalslink.easiersbs.matching.service.api.SBSFactory;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.matcher.SyntacticMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityMeasure;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.matcher.AbstractMatcherImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatcherPropertiesImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatchingResultImpl;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.List;
import java.util.Set;

public class SyntacticMatcherImpl
extends AbstractMatcherImpl
implements SyntacticMatcher {
    private SBSFactory factory = SBSFactoryImpl.getInstance();
    private SimilarityMeasure similarity;

    public SyntacticMatcherImpl(SemanticRegistryManager semanticRegistryManager, MatcherProperties matcherProperties) throws EasierSBSException {
        this.registry = semanticRegistryManager;
        this.props = matcherProperties;
        this.similarity = this.factory.newSimilarityMeasure(matcherProperties.getSimilarityType(), matcherProperties.getLevenshteinLimit());
    }

    public SyntacticMatcherImpl(SemanticRegistryManager semanticRegistryManager) throws EasierSBSException {
        this(semanticRegistryManager, new MatcherPropertiesImpl());
    }

    public SimilarityMeasure getSimilarityMeasure() {
        return this.similarity;
    }

    @Override
    public MatchingResult findServices(SearchProfile searchProfile, Set<SemanticProfile> set) {
        MatchingResultImpl matchingResultImpl = new MatchingResultImpl(searchProfile);
        List<String> list = SimilarityUtil.extractUriRelatedWords(searchProfile.getSemanticOperation().getSemanticConcepts());
        list.addAll(SimilarityUtil.extractUriRelatedWords(searchProfile.getSemanticInterface().getSemanticConcepts()));
        List<String> list2 = SimilarityUtil.extractElementRelatedWords(searchProfile.getInputSemanticElements());
        List<String> list3 = SimilarityUtil.extractElementRelatedWords(searchProfile.getOutputSemanticElements());
        for (SemanticProfile semanticProfile : set) {
            List<String> list4;
            double d = 0.0;
            Double d2 = null;
            Double d3 = null;
            if (this.props.getOperationWeight() != 0.0) {
                list4 = SimilarityUtil.extractUriRelatedWords(semanticProfile.getSemanticOperation().getSemanticConcepts());
                list4.addAll(SimilarityUtil.extractUriRelatedWords(semanticProfile.getSemanticInterface().getSemanticConcepts()));
                d3 = this.similarity.measureSimilarity(list, list4);
            }
            if (this.props.getInputOutputWeigth() != 0.0) {
                list4 = SimilarityUtil.extractElementRelatedWords(semanticProfile.getInputSemanticElements());
                double d4 = this.similarity.measureSimilarity(list2, list4);
                List<String> list5 = SimilarityUtil.extractElementRelatedWords(semanticProfile.getOutputSemanticElements());
                double d5 = this.similarity.measureSimilarity(list3, list5);
                d2 = (d4 + d5) / 2.0;
            }
            if (!((d = d2 == null || d2.isNaN() ? d3 : (d3 == null || d3.isNaN() ? d2 : d2 * this.props.getInputOutputWeigth() + d3 * this.props.getOperationWeight())) >= this.props.getSyntacticThreshold())) continue;
            matchingResultImpl.addResultProfile(semanticProfile, d);
        }
        return matchingResultImpl;
    }
}

