/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.HashMap;
import java.util.Map;

public class MatchingResultImpl
implements MatchingResult {
    private Map<SemanticProfile, Double> profiles = new HashMap<SemanticProfile, Double>();
    private SearchProfile query;

    public MatchingResultImpl(SearchProfile searchProfile) {
        this.query = searchProfile;
    }

    public SearchProfile getQuery() {
        return this.query;
    }

    public Map<SemanticProfile, Double> getResultProfiles() {
        return this.profiles;
    }

    public void addResultProfile(SemanticProfile semanticProfile, double d) {
        this.profiles.put(semanticProfile, d);
    }

    public void removeResultProfile(SemanticProfile semanticProfile) {
        this.profiles.remove(semanticProfile);
    }

    public boolean hasExactProfile() {
        return this.profiles.containsValue(1.0);
    }

    public boolean hasCorrectProfile(double d) {
        for (double d2 : this.profiles.values()) {
            if (!(d2 > d)) continue;
            return true;
        }
        return false;
    }

    public SemanticProfile getBestProfile() {
        SemanticProfile semanticProfile = null;
        Double d = 0.0;
        for (Map.Entry<SemanticProfile, Double> entry : this.profiles.entrySet()) {
            if (semanticProfile != null && !(entry.getValue() > d)) continue;
            semanticProfile = entry.getKey();
            d = entry.getValue();
        }
        return semanticProfile;
    }
}

