/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher.similarity;

import com.petalslink.easiersbs.matching.service.matcher.similarity.AbstractSimilarityMeasureImpl;
import com.petalslink.easiersbs.matching.service.matcher.similarity.DoubleVector;
import com.petalslink.easiersbs.matching.service.util.VectorUtil;
import java.util.List;
import java.util.Map;

public class JaccardSimilarityImpl
extends AbstractSimilarityMeasureImpl {
    public JaccardSimilarityImpl() {
    }

    public JaccardSimilarityImpl(int n) {
        super.setLevenshteinLimit(n);
    }

    public double measureSimilarity(List<String> list, List<String> list2) {
        if (list.isEmpty() || list2.isEmpty()) {
            return 0.0;
        }
        Map<String, Integer> map = this.countWordFrequency(list);
        Map<String, Integer> map2 = this.countWordFrequency(list2);
        DoubleVector doubleVector = this.getProperVectors(map, map2);
        double d = VectorUtil.dotProduct(doubleVector.getVector1(), doubleVector.getVector2());
        double d2 = (double)(VectorUtil.dotProduct(doubleVector.getVector1(), doubleVector.getVector1()) + VectorUtil.dotProduct(doubleVector.getVector2(), doubleVector.getVector2())) - d;
        double d3 = d2 == 0.0 ? 0.0 : d / d2;
        logger.finest("Jaccard similarity fully measured: " + d3);
        return d3;
    }
}

