/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.profile;

import java.net.URI;
import java.util.Set;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.Part;
import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedPart;
import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedSemanticConcept;
import com.petalslink.easiersbs.matching.service.profile.infered.InferedSemanticConceptImpl;
import com.petalslink.easiersbs.matching.service.profile.infered.InferedSemanticPartImpl;
import com.petalslink.easiersbs.matching.service.profile.infered.RatedURIImpl;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticPartImpl;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class PartImpl extends SemanticPartImpl implements Part {

	
	public PartImpl(){
		super();
	}
	
	public PartImpl(Set<URI> concepts){
		super(concepts);
	}
	
	public PartImpl(SemanticPart part){
		super(part.getSemanticConcepts());
		this.setName(part.getName());
	}
	
	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.SemanticPart#infer()
	 */
	@Override
	public InferedPart infer(Reasoner reasoner, MatcherProperties props) {
		InferedPart result = new InferedSemanticPartImpl();
		
		for(URI concept : this.getSemanticConcepts()){

			InferedSemanticConcept inferedConcept = new InferedSemanticConceptImpl();
			// Direct concept
			inferedConcept.addRatedSemanticConcept(new RatedURIImpl(concept, 1.0));
			
			if(reasoner.isConcept(concept)){
				// Equivalent concepts
				for(URI eqConcept : reasoner.getEquivalentClasses(concept)){
					if(!reasoner.isThingOrNothing(eqConcept)){
						inferedConcept.addRatedSemanticConcept(new RatedURIImpl(eqConcept, props.getEquivalentMark()));
					}
				}
				
				// Specialization concepts
				Set<URI> specConcepts = reasoner.getSubClasses(concept);
				specConcepts.addAll(reasoner.getIndividuals(concept));
				for(URI specConcept : specConcepts){
					if(!reasoner.isThingOrNothing(specConcept)){
						inferedConcept.addRatedSemanticConcept(new RatedURIImpl(specConcept, props.getSpecializationMark()));
					}
				}
				
				// Generalization concepts
				for(URI genConcept : reasoner.getSuperClasses(concept)){
					if(!reasoner.isThingOrNothing(genConcept)){
						inferedConcept.addRatedSemanticConcept(new RatedURIImpl(genConcept, props.getGeneralizationMark()));
					}
				}
				
			} else if (reasoner.isInstance(concept)) { // URI refers to an instance
				// Equivalent instances
				for(URI eqInstance : reasoner.getSimilarIndividuals(concept)){
					inferedConcept.addRatedSemanticConcept(new RatedURIImpl(eqInstance, props.getEquivalentMark()));
				}
				
				// Parent concepts
				for(URI genConcept : reasoner.getTypes(concept)){
					if(!reasoner.isThingOrNothing(genConcept)){
						inferedConcept.addRatedSemanticConcept(new RatedURIImpl(genConcept, props.getGeneralizationMark()));
					}
				}
			}
		
			result.addInferedSemanticConcept(inferedConcept);
		}
		
		return result;
	}
	
	public String toString(){
		return this.getSemanticConcepts().toString();
	}

}
