/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.SBSFactoryImpl;
import com.petalslink.easiersbs.matching.service.api.EasierSBSException;
import com.petalslink.easiersbs.matching.service.api.SBSFactory;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.matcher.SyntacticMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityMeasure;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.matcher.AbstractMatcherImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatcherPropertiesImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatchingResultImpl;
import com.petalslink.easiersbs.matching.service.matcher.computation.SyntacticComputationImpl;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class SyntacticMatcherImpl
extends AbstractMatcherImpl
implements SyntacticMatcher {
    private SBSFactory factory = SBSFactoryImpl.getInstance();
    private SimilarityMeasure similarity;
    private ExecutorService exec;
    private ExecutorCompletionService<Double> compExec;

    public SyntacticMatcherImpl(SemanticRegistryManager semanticRegistryManager, MatcherProperties matcherProperties) throws EasierSBSException {
        this.registry = semanticRegistryManager;
        this.props = matcherProperties;
        this.similarity = this.factory.newSimilarityMeasure(matcherProperties.getSimilarityType(), matcherProperties.getLevenshteinLimit());
        this.exec = Executors.newFixedThreadPool(matcherProperties.getMaxThreads());
        this.compExec = new ExecutorCompletionService(this.exec);
    }

    public SyntacticMatcherImpl(SemanticRegistryManager semanticRegistryManager) throws EasierSBSException {
        this(semanticRegistryManager, new MatcherPropertiesImpl());
    }

    public SimilarityMeasure getSimilarityMeasure() {
        return this.similarity;
    }

    @Override
    public MatchingResult findServices(SearchProfile searchProfile, Set<SemanticProfile> set) {
        MatchingResultImpl matchingResultImpl = new MatchingResultImpl(searchProfile);
        try {
            this.similarity = this.factory.newSimilarityMeasure(this.props.getSimilarityType(), this.props.getLevenshteinLimit());
        }
        catch (EasierSBSException easierSBSException) {
            easierSBSException.printStackTrace();
        }
        List<String> list = SimilarityUtil.extractUriRelatedWords(searchProfile.getSemanticOperation().getSemanticConcepts());
        list.addAll(SimilarityUtil.extractUriRelatedWords(searchProfile.getSemanticInterface().getSemanticConcepts()));
        List<String> list2 = SimilarityUtil.extractElementRelatedWords(searchProfile.getInputSemanticElements());
        List<String> list3 = SimilarityUtil.extractElementRelatedWords(searchProfile.getOutputSemanticElements());
        HashMap<SemanticProfile, Future<Double>> hashMap = new HashMap<SemanticProfile, Future<Double>>();
        for (SemanticProfile object : set) {
            SyntacticComputationImpl syntacticComputationImpl = new SyntacticComputationImpl(this.props, this.similarity, list, list2, list3, object);
            Future<Double> future = this.compExec.submit(syntacticComputationImpl);
            hashMap.put(object, future);
        }
        boolean bl = false;
        while (!bl) {
            bl = true;
            for (Future future : hashMap.values()) {
                if (future.isDone()) continue;
                bl = false;
            }
            if (bl) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            try {
                if (!((Double)((Future)entry.getValue()).get() >= this.props.getSyntacticThreshold())) continue;
                matchingResultImpl.addResultProfile((SemanticProfile)entry.getKey(), (Double)((Future)entry.getValue()).get());
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (ExecutionException executionException) {
                throw new RuntimeException(executionException);
            }
        }
        return matchingResultImpl;
    }
}

