/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.profile;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.SearchElement;
import com.petalslink.easiersbs.matching.service.api.profile.SearchPart;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredProfile;
import com.petalslink.easiersbs.matching.service.profile.inferred.InferredProfileImpl;
import com.petalslink.easiersbs.matching.service.util.ProfileUtil;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.impl.model.generic.GenericProfileImpl;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class SearchProfileImpl extends GenericProfileImpl<SearchPart, SearchElement> implements SearchProfile {
	
	public SearchProfileImpl(){
		
	}
	
	public SearchProfileImpl(SemanticProfile profile){
		this.partner = profile.getPartner();
		this.operationQName = profile.getOperationQName();
		this.semanticInterface = new SearchPartImpl(profile.getSemanticInterface());
		this.semanticOperation = new SearchPartImpl(profile.getSemanticOperation());
		this.semanticInput = ProfileUtil.convertSemanticElement(profile.getInputSemanticElement());
		if(profile.getOutputSemanticElement() != null) {
			this.semanticOutput = ProfileUtil.convertSemanticElement(profile.getOutputSemanticElement());
		}
	}
	
	public SearchProfileImpl(SearchPart semanticInterface, SearchPart semanticOperation, 
				SearchElement semanticInput, SearchElement semanticOutput){
		this.semanticInterface = semanticInterface;
		this.semanticOperation = semanticOperation;
		this.semanticInput = semanticInput;
		this.semanticOutput = semanticOutput;
	}

	@Override
	public InferredProfile infer(Reasoner reasoner, MatcherProperties props) {
		InferredProfile result = new InferredProfileImpl();
		result.setPartner(partner);
		result.setSemanticInterface(semanticInterface.infer(reasoner, props));
		result.setSemanticOperation(semanticOperation.infer(reasoner, props));
		result.setInputSemanticElement(semanticInput.infer(reasoner, props));
		if(semanticOutput != null) {
			result.setOutputSemanticElement(semanticOutput.infer(reasoner, props));
		}
		return result;
	}

	@Override
	public boolean equals(Object other) {
		if(other instanceof SearchProfile){
			if((this.semanticInterface != null && !this.semanticInterface.equals(((SearchProfile)other).getSemanticInterface()))
					|| (this.semanticOperation != null && !this.semanticOperation.equals(((SearchProfile)other).getSemanticOperation()))
					|| (this.semanticInput != null && !this.semanticInput.equals(((SearchProfile)other).getInputSemanticElement()))
					|| (this.semanticOutput != null && !this.semanticOutput.equals(((SearchProfile)other).getOutputSemanticElement()))){
				return false;
			} else {
				return true;
			}
		}else{
			return false;
		}
	}
	
	@Override
	public int hashCode() {
		return this.toString().hashCode();
	}
	
	@Override
	public String toString(){
		String res = "SearchProfile";
		res += super.toString();
		return res;
	}
	
}