/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher.computation;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityMeasure;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.matching.service.profile.rated.RatedSemanticProfileImpl;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;
import java.util.List;
import java.util.concurrent.Callable;

public class SyntacticComputationImpl
implements Callable<RatedSemanticProfile> {
    private MatcherProperties props;
    private SimilarityMeasure similarity;
    private List<String> functionalWords;
    private List<String> inputWords;
    private List<String> outputWords;
    private SemanticProfile service;

    public SyntacticComputationImpl(MatcherProperties matcherProperties, SimilarityMeasure similarityMeasure, List<String> list, List<String> list2, List<String> list3, SemanticProfile semanticProfile) {
        this.props = matcherProperties;
        this.similarity = similarityMeasure;
        this.functionalWords = list;
        this.inputWords = list2;
        this.outputWords = list3;
        this.service = semanticProfile;
    }

    @Override
    public RatedSemanticProfile call() throws Exception {
        List<String> list;
        RatedSemanticProfileImpl ratedSemanticProfileImpl = new RatedSemanticProfileImpl(this.service);
        Double d = null;
        Double d2 = null;
        if (this.props.getOperationWeight() != 0.0) {
            list = SimilarityUtil.extractUriRelatedWords(((SemanticPart)this.service.getSemanticOperation()).getSemanticConcepts());
            list.addAll(SimilarityUtil.splitInWords(((SemanticPart)this.service.getSemanticOperation()).getName()));
            list.addAll(SimilarityUtil.extractUriRelatedWords(((SemanticPart)this.service.getSemanticInterface()).getSemanticConcepts()));
            list.addAll(SimilarityUtil.splitInWords(((SemanticPart)this.service.getSemanticInterface()).getName()));
            d = this.similarity.measureSimilarity(this.functionalWords, list);
            ratedSemanticProfileImpl.setOperationRate(d);
        }
        if (this.props.getInputOutputWeigth() != 0.0) {
            list = SimilarityUtil.extractElementRelatedWords(ServiceUtil.getFlattenElements((GenericElement)this.service.getInputSemanticElement()));
            ratedSemanticProfileImpl.setInputRate(this.similarity.measureSimilarity(this.inputWords, list));
            List<String> list2 = SimilarityUtil.extractElementRelatedWords(ServiceUtil.getFlattenElements((GenericElement)this.service.getOutputSemanticElement()));
            ratedSemanticProfileImpl.setOutputRate(this.similarity.measureSimilarity(this.outputWords, list2));
            d2 = (ratedSemanticProfileImpl.getInputRate() + ratedSemanticProfileImpl.getOutputRate()) / 2.0;
        }
        if (d2 == null || d2.isNaN()) {
            ratedSemanticProfileImpl.setProfileRate(d);
        } else if (d == null || d.isNaN()) {
            ratedSemanticProfileImpl.setProfileRate(d2);
        } else {
            ratedSemanticProfileImpl.setProfileRate(d2 * this.props.getInputOutputWeigth() + d * this.props.getOperationWeight());
        }
        return ratedSemanticProfileImpl;
    }
}

