/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.util;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.SearchElement;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredConcept;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredElement;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.RatedURI;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.matching.service.profile.SearchElementImpl;
import com.petalslink.easiersbs.matching.service.profile.inferred.InferredConceptImpl;
import com.petalslink.easiersbs.matching.service.profile.inferred.RatedURIImpl;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.xml.namespace.QName;

public class ProfileUtil {
    public static Set<RatedURI> getFlattenRatedUris(InferredElement inferredElement) {
        HashSet<InferredElement> hashSet = new HashSet<InferredElement>();
        return ProfileUtil.getFlattenRatedUris(inferredElement, hashSet);
    }

    private static Set<RatedURI> getFlattenRatedUris(InferredElement inferredElement, Set<InferredElement> set) {
        HashSet<RatedURI> hashSet = new HashSet<RatedURI>();
        if (!set.contains(inferredElement)) {
            set.add(inferredElement);
            for (InferredConcept inferredConcept : inferredElement.getInferedSemanticConcepts()) {
                hashSet.addAll(inferredConcept.getRatedSemanticConcepts());
            }
            for (InferredConcept inferredConcept : inferredElement.getChildElements()) {
                hashSet.addAll(ProfileUtil.getFlattenRatedUris((InferredElement)inferredConcept, set));
            }
        }
        return hashSet;
    }

    public static SearchElement convertSemanticElement(SemanticElement semanticElement) {
        return ProfileUtil.convertSemanticElementHierarchy(semanticElement, new HashMap<QName, SearchElement>());
    }

    private static SearchElement convertSemanticElementHierarchy(SemanticElement semanticElement, Map<QName, SearchElement> map) {
        SearchElementImpl searchElementImpl = new SearchElementImpl();
        searchElementImpl.setSemanticConcepts(semanticElement.getSemanticConcepts());
        searchElementImpl.setElementQName(semanticElement.getElementQName());
        searchElementImpl.setName(semanticElement.getName());
        searchElementImpl.setRequired(semanticElement.isRequired());
        map.put(semanticElement.getElementQName(), searchElementImpl);
        for (SemanticElement semanticElement2 : semanticElement.getChildElements()) {
            if (map.containsKey(semanticElement2.getElementQName())) {
                searchElementImpl.addChildElement((GenericElement)map.get(semanticElement2.getElementQName()));
                continue;
            }
            searchElementImpl.addChildElement((GenericElement)ProfileUtil.convertSemanticElementHierarchy(semanticElement2, map));
        }
        return searchElementImpl;
    }

    public static InferredConcept inferConcept(URI uRI, Reasoner reasoner, MatcherProperties matcherProperties) {
        InferredConceptImpl inferredConceptImpl;
        block6: {
            block5: {
                Object object2;
                inferredConceptImpl = new InferredConceptImpl();
                inferredConceptImpl.addRatedSemanticConcept(new RatedURIImpl(uRI, 1.0));
                if (!reasoner.isConcept(uRI)) break block5;
                for (Object object2 : reasoner.getEquivalentClasses(uRI)) {
                    if (reasoner.isThingOrNothing((URI)object2)) continue;
                    inferredConceptImpl.addRatedSemanticConcept(new RatedURIImpl((URI)object2, matcherProperties.getEquivalentMark()));
                }
                Set set = reasoner.getSubClasses(uRI);
                set.addAll(reasoner.getIndividuals(uRI));
                object2 = set.iterator();
                while (object2.hasNext()) {
                    URI uRI2 = (URI)object2.next();
                    if (reasoner.isThingOrNothing(uRI2)) continue;
                    inferredConceptImpl.addRatedSemanticConcept(new RatedURIImpl(uRI2, matcherProperties.getSpecializationMark()));
                }
                for (URI uRI2 : reasoner.getSuperClasses(uRI)) {
                    if (reasoner.isThingOrNothing(uRI2)) continue;
                    inferredConceptImpl.addRatedSemanticConcept(new RatedURIImpl(uRI2, matcherProperties.getGeneralizationMark()));
                }
                break block6;
            }
            if (!reasoner.isInstance(uRI)) break block6;
            for (URI uRI3 : reasoner.getSimilarIndividuals(uRI)) {
                inferredConceptImpl.addRatedSemanticConcept(new RatedURIImpl(uRI3, matcherProperties.getEquivalentMark()));
            }
            for (URI uRI3 : reasoner.getTypes(uRI)) {
                if (reasoner.isThingOrNothing(uRI3)) continue;
                inferredConceptImpl.addRatedSemanticConcept(new RatedURIImpl(uRI3, matcherProperties.getGeneralizationMark()));
            }
        }
        return inferredConceptImpl;
    }

    public static Set<SemanticProfile> getSemanticProfiles(SortedSet<RatedSemanticProfile> sortedSet) {
        HashSet<SemanticProfile> hashSet = new HashSet<SemanticProfile>();
        for (RatedSemanticProfile ratedSemanticProfile : sortedSet) {
            hashSet.add(ratedSemanticProfile.getProfile());
        }
        return hashSet;
    }
}

