/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * WSOUIProvider.java
 *
 */

package org.petalslink.easiestdemo.wsoui.provided;

import java.awt.Color;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;

import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Fault;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.Output;
import org.petalslink.easiestdemo.client.gui.edit.XMLEditorKit;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration.PositionType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easiestdemo.contant.EasiestDEMOFramework;
import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.lang.reflect.ReflectionHelper;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyschema.xsd2xml.XSD2XML;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.ComplexType;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Subscribe;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse;
import com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.GetResourcePropertyResponse;

/**
 *
 * @author nsalatge
 */
public class WSOUIProvider extends javax.swing.JFrame {

	private static Logger LOG = Logger.getLogger(WSOUIProvider.class.getName());
	private static final String OUT = "out";
	private static final URL BACKGROUND_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/fond_ecran_sombre_572x972.png");
	private static final URL DEFAULT_PROVIDER_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/provider.png");
	private static final URL ICON_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/easylink-ico.png");


	private Description description = null; 

	private DefaultListModel model = new DefaultListModel();
	public String responseType = OUT;
	private String _serviceName = null;
	private String _endpointName = null;
	private Object _request = null;
	private Object response = null;
	private String _operationName;
	private Class<?> expectedReturnType = null;
	private Element responseDefinition = null;
	private WSOUIJaxbContextItf wsouiContext = null;
	private ProviderConfiguration configuration = null;
	private AbstractImplementationManager<?> im = null;


	/** Creates new form WSOUIProvider */
	public WSOUIProvider(AbstractImplementationManager<?> im, URL wsdlUrl, ProviderConfiguration configuration) throws WSOUIException {
		initComponents();

		this.jEditorPaneRequest.setEditorKit(new XMLEditorKit());
		this.jEditorPaneResponse.setEditorKit(new XMLEditorKit());
		this.setBackground(new Color(204,102,255));
		this.configuration = configuration; 
		if(im != null) {
			this.setTitle(im.getTestImplementation().getClass().getInterfaces()[0].getSimpleName());
			this.im = im;
		}
		this.setIconImage(Toolkit.getDefaultToolkit().getImage(ICON_IMAGE));

		if(wsdlUrl != null) {
			// read WSDL 1.1 definitions from url
			try {
				Definitions definitions = SOAUtil.getInstance().getReader(EasiestDEMOFramework.getInstance()).get().readDocument(wsdlUrl, Definitions.class);
				this.description = (Description) Factory.getInstance().wrap(definitions);
			} catch (XmlObjectReadException e) {
				throw new WSOUIException(e);
			}
		}



		if(this.configuration != null && this.configuration.getPosition() != null) {
			this.setLocation(configuration.getPosition());
		} else {
			this.setLocation(PositionType.NORTH_WEST);
		}

		ImageIcon img = new ImageIcon(DEFAULT_PROVIDER_IMAGE);
		if(this.configuration != null && this.configuration.getImage() != null) {
			img = new ImageIcon(this.configuration.getImage());
		} 
		this.jLabelImage.setIcon(img);

	}


	public javax.swing.JEditorPane getjEditorPaneResponse() {
		return jEditorPaneResponse;
	}


	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPaneMain = new javax.swing.JScrollPane();
        jPanelMain = new javax.swing.JPanel();
        jPanelRequest = new javax.swing.JPanel();
        jScrollPaneRequest = new javax.swing.JScrollPane();
        jEditorPaneRequest = new javax.swing.JEditorPane();
        jPanelServiceInformations = new javax.swing.JPanel();
        jLabelServiceQName = new javax.swing.JLabel();
        jTextFieldServiceQName = new javax.swing.JTextField();
        jLabelInterfaceQName = new javax.swing.JLabel();
        jTextFieldInterfaceQName = new javax.swing.JTextField();
        jLabelEndpointName = new javax.swing.JLabel();
        jTextFieldEndpointName = new javax.swing.JTextField();
        jLabelOperationName = new javax.swing.JLabel();
        jTextFieldOperationName = new javax.swing.JTextField();
        jPanelImage = new javax.swing.JPanel();
        jLabelImage = new javax.swing.JLabel();
        jPanelResponse = new javax.swing.JPanel();
        jScrollPaneResponse = new javax.swing.JScrollPane();
        jEditorPaneResponse = new javax.swing.JEditorPane();
        jScrollPaneResponseType = new javax.swing.JScrollPane();
        jListResponseType = new javax.swing.JList();
        jLabelResponseType = new javax.swing.JLabel();
        jPanelCommand = new javax.swing.JPanel();
        jButtonSendResponse = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        jScrollPaneMain.setViewportBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        jScrollPaneMain.setHorizontalScrollBar(null);

        jPanelMain.setBackground(new java.awt.Color(220, 232, 232));

        jPanelRequest.setBorder(javax.swing.BorderFactory.createTitledBorder("Request:"));
        jPanelRequest.setOpaque(false);

        jScrollPaneRequest.setViewportView(jEditorPaneRequest);

        javax.swing.GroupLayout jPanelRequestLayout = new javax.swing.GroupLayout(jPanelRequest);
        jPanelRequest.setLayout(jPanelRequestLayout);
        jPanelRequestLayout.setHorizontalGroup(
            jPanelRequestLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelRequestLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPaneRequest, javax.swing.GroupLayout.PREFERRED_SIZE, 762, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(168, Short.MAX_VALUE))
        );
        jPanelRequestLayout.setVerticalGroup(
            jPanelRequestLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPaneRequest, javax.swing.GroupLayout.DEFAULT_SIZE, 179, Short.MAX_VALUE)
        );

        jPanelServiceInformations.setBorder(javax.swing.BorderFactory.createTitledBorder("Service Informations"));
        jPanelServiceInformations.setOpaque(false);

        jLabelServiceQName.setText("Service QName:");

        jTextFieldServiceQName.setEditable(false);

        jLabelInterfaceQName.setText("Interface QName:");

        jTextFieldInterfaceQName.setEditable(false);

        jLabelEndpointName.setText("Endpoint Name:");

        jTextFieldEndpointName.setEditable(false);

        jLabelOperationName.setText("Operation Name:");

        jTextFieldOperationName.setEditable(false);

        jLabelImage.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);

        javax.swing.GroupLayout jPanelImageLayout = new javax.swing.GroupLayout(jPanelImage);
        jPanelImage.setLayout(jPanelImageLayout);
        jPanelImageLayout.setHorizontalGroup(
            jPanelImageLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelImageLayout.createSequentialGroup()
                .addComponent(jLabelImage, javax.swing.GroupLayout.DEFAULT_SIZE, 161, Short.MAX_VALUE)
                .addContainerGap())
        );
        jPanelImageLayout.setVerticalGroup(
            jPanelImageLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jLabelImage, javax.swing.GroupLayout.DEFAULT_SIZE, 133, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout jPanelServiceInformationsLayout = new javax.swing.GroupLayout(jPanelServiceInformations);
        jPanelServiceInformations.setLayout(jPanelServiceInformationsLayout);
        jPanelServiceInformationsLayout.setHorizontalGroup(
            jPanelServiceInformationsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelServiceInformationsLayout.createSequentialGroup()
                .addContainerGap(12, Short.MAX_VALUE)
                .addGroup(jPanelServiceInformationsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabelInterfaceQName)
                    .addComponent(jLabelServiceQName)
                    .addComponent(jLabelEndpointName)
                    .addComponent(jLabelOperationName))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelServiceInformationsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jTextFieldOperationName)
                    .addComponent(jTextFieldEndpointName)
                    .addComponent(jTextFieldInterfaceQName)
                    .addComponent(jTextFieldServiceQName, javax.swing.GroupLayout.DEFAULT_SIZE, 646, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanelImage, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanelServiceInformationsLayout.setVerticalGroup(
            jPanelServiceInformationsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelServiceInformationsLayout.createSequentialGroup()
                .addGroup(jPanelServiceInformationsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelServiceInformationsLayout.createSequentialGroup()
                        .addGroup(jPanelServiceInformationsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabelServiceQName)
                            .addComponent(jTextFieldServiceQName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanelServiceInformationsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabelInterfaceQName)
                            .addComponent(jTextFieldInterfaceQName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanelServiceInformationsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabelEndpointName)
                            .addComponent(jTextFieldEndpointName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanelServiceInformationsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabelOperationName)
                            .addComponent(jTextFieldOperationName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addComponent(jPanelImage, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(16, 16, 16))
        );

        jPanelResponse.setBorder(javax.swing.BorderFactory.createTitledBorder("Response:"));
        jPanelResponse.setOpaque(false);

        jScrollPaneResponse.setViewportView(jEditorPaneResponse);

        jListResponseType.setModel(model);
        jListResponseType.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jListResponseTypeMouseClicked(evt);
            }
        });
        jScrollPaneResponseType.setViewportView(jListResponseType);

        jLabelResponseType.setText("Response type");

        javax.swing.GroupLayout jPanelResponseLayout = new javax.swing.GroupLayout(jPanelResponse);
        jPanelResponse.setLayout(jPanelResponseLayout);
        jPanelResponseLayout.setHorizontalGroup(
            jPanelResponseLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelResponseLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPaneResponse, javax.swing.GroupLayout.PREFERRED_SIZE, 762, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(27, 27, 27)
                .addGroup(jPanelResponseLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPaneResponseType, javax.swing.GroupLayout.PREFERRED_SIZE, 107, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabelResponseType))
                .addGap(407, 407, 407))
        );
        jPanelResponseLayout.setVerticalGroup(
            jPanelResponseLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPaneResponse, javax.swing.GroupLayout.DEFAULT_SIZE, 195, Short.MAX_VALUE)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelResponseLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabelResponseType)
                .addGap(10, 10, 10)
                .addComponent(jScrollPaneResponseType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(11, 11, 11))
        );

        jPanelCommand.setOpaque(false);

        jButtonSendResponse.setText("Send");
        jButtonSendResponse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSendResponseActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelCommandLayout = new javax.swing.GroupLayout(jPanelCommand);
        jPanelCommand.setLayout(jPanelCommandLayout);
        jPanelCommandLayout.setHorizontalGroup(
            jPanelCommandLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelCommandLayout.createSequentialGroup()
                .addContainerGap(812, Short.MAX_VALUE)
                .addComponent(jButtonSendResponse, javax.swing.GroupLayout.PREFERRED_SIZE, 121, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanelCommandLayout.setVerticalGroup(
            jPanelCommandLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelCommandLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jButtonSendResponse, javax.swing.GroupLayout.DEFAULT_SIZE, 37, Short.MAX_VALUE)
                .addContainerGap())
        );

        javax.swing.GroupLayout jPanelMainLayout = new javax.swing.GroupLayout(jPanelMain);
        jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(
            jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelMainLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanelCommand, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                        .addComponent(jPanelRequest, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jPanelServiceInformations, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jPanelResponse, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 952, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(575, 575, 575))
        );
        jPanelMainLayout.setVerticalGroup(
            jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelMainLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanelServiceInformations, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelRequest, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelResponse, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelCommand, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        jScrollPaneMain.setViewportView(jPanelMain);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPaneMain, javax.swing.GroupLayout.DEFAULT_SIZE, 979, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPaneMain, javax.swing.GroupLayout.DEFAULT_SIZE, 711, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

	private void jListResponseTypeMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jListResponseTypeMouseClicked
		listHandler(evt);
	}//GEN-LAST:event_jListResponseTypeMouseClicked

	private void jButtonSendResponseActionPerformed(java.awt.event.ActionEvent evt) {
		try {
			InputStream is = new ByteArrayInputStream(this.jEditorPaneResponse.getText().getBytes());
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
			is.close();
			Class<?> clazz = getWsouiContext().findJaxClassFromElementQName(responseDefinition.inferQName());
			response = getWsouiContext().unmarshallAnyType(doc, clazz);

			getFrame().setVisible(false);
			synchronized (im.getLock()) {
				im.getLock().notify();
			}
			
		} catch (SAXException e1) {
			JOptionPane.showMessageDialog(null, e1.getMessage());
			e1.printStackTrace();
		} catch (IOException e1) {
			JOptionPane.showMessageDialog(null, e1.getMessage());
			e1.printStackTrace();
		} catch (ParserConfigurationException e1) {
			JOptionPane.showMessageDialog(null, e1.getMessage());
			e1.printStackTrace();
		} catch (WSOUIException e1) {
			JOptionPane.showMessageDialog(null, e1.getMessage());
			e1.printStackTrace();
		} 
	}

	private JFrame getFrame() {
		return this;
	}

	public String getResponseType() {
		return this.responseType;
	}

	private void setLocation(PositionType position) {
		double witdhFrame = this.getBounds().getWidth();
		double heightFrame = this.getBounds().getHeight();
		double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
		double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
		int x = 0;
		int y = 0;

		try {
			if(position.equals(PositionType.NORTH_WEST)) {
				x = 0 + new Random().nextInt((int) ((witdhScreen/2)-(witdhFrame/2)));
				y = 0 + new Random().nextInt((int) ((heightScreen/2)-(heightFrame/2)));
			} else if(position.equals(PositionType.NORTH_EAST)) {
				x = 0 + new Random().nextInt((int) (((witdhScreen/2)- (witdhFrame/2))))  + (int)(witdhScreen/2) - (int)(witdhFrame/2);
				y = 0 + new Random().nextInt((int) ((heightScreen/2)-(heightFrame/2)));
			} else if(position.equals(PositionType.SOUTH_WEST)) {
				x = 0 + new Random().nextInt((int) (((witdhScreen/2)- (witdhFrame/2))));
				y = 0 + new Random().nextInt((int) (((heightScreen/2)- (heightFrame/2)))) + (int)(heightScreen/2) - (int)(heightFrame/2);
			} else if(position.equals(PositionType.SOUTH_EAST)) {
				x = 0 + new Random().nextInt((int) (((witdhScreen/2)-(witdhFrame/2)))) + (int)(witdhScreen/2) - (int)(witdhFrame/2);
				y = 0 + new Random().nextInt((int) (((heightScreen/2)-(heightFrame/2)))) + (int)(heightScreen/2) - (int)(heightFrame/2);
			} 
		} catch (IllegalArgumentException e) {
			// do nothing
		}
		this.setLocation(x, y);
	}

	public Object getResponse() {
		if(response != null) {
			if(!response.getClass().getName().equals(expectedReturnType.getName())) {
				if(expectedReturnType.getName().equals(String.class.getName())) {
					Collection<Method> methods = ReflectionHelper.findMethodsThatReturnType(response.getClass(), expectedReturnType);
					if(methods.size() > 1) {
						Method m = methods.iterator().next();
						try {
							response = ReflectionHelper.invokeMethod(response, m);
						} catch (InvocationTargetException e) {
							// do nothing
							e.printStackTrace();
						}
					}
				}
			}
		}
		return response;
	}

	public void setExchangeInformations(String serviceName, String endpointName, String operationName, Object request, Object response, Class<?> expectedReturnType, String responseType) {

		this._serviceName = serviceName;
		this._endpointName = endpointName;
		this._operationName = operationName;
		this._request = request;
		this.response = response;

		this.jTextFieldServiceQName.setText(serviceName);
		this.jTextFieldEndpointName.setText(endpointName);
		this.jTextFieldOperationName.setText(operationName);
		this.expectedReturnType = expectedReturnType;

		Endpoint ep = this.description.findEndpoint(endpointName);
		this.jTextFieldInterfaceQName.setText(ep.getBinding().getInterface().getQName().toString());
		Operation op = null;
		for(Operation operation: ep.getBinding().getInterface().getOperations()) {
			if(operation.getName().toLowerCase().equals(operationName.toLowerCase())) {
				op = operation;
			}
		}
		if(op != null) {


			/* Add fill of list */
			fillResponseList(ep.getBinding().getInterface().getQName(), op.inferQName());

			Element inputElmt = op.getInput().getElement();
			responseDefinition = op.getOutput().getElement();

			if(OUT.equals(this.responseType)){
				responseDefinition = op.getOutput().getElement();
			}else{
				for(int i=0 ; i < op.getFaults().length ; i++){
					if(responseType.equals(op.getFaults()[i].getName())){
						responseDefinition = op.getFaults()[i].getMessage();
					}
				}
			}


			String requestDOM = createDocument(request, inputElmt);
			String responseDOM = createDocument(response, responseDefinition);

			this.jEditorPaneRequest.setText(requestDOM);
			this.jEditorPaneResponse.setText(responseDOM);
		} else {
			JOptionPane.showMessageDialog(this, "Impossible to find in interface " + ep.getBinding().getInterface().getQName() + " an operation corresponding to " + operationName, "Error", JOptionPane.ERROR_MESSAGE);
		}

		this.setAlwaysOnTop(true);
		this.validate();
	}



	private void fillResponseList(QName itfName, QName operation) {

		this.model.removeAllElements();
		List<String> datalist = new ArrayList<String>();
		Interface itf = this.description.findInterface(itfName);

		Output out = itf.getOperation(operation).getOutput();
		if(out != null){
			datalist.add("out");
			model.addElement("out");
		}
		Fault[] faults = itf.getOperation(operation).getFaults();
		for(int i=0 ; i < faults.length ; i++){
			datalist.add(faults[i].getName());
			model.addElement(faults[i].getName());
		}
	}



	private String createDocument(Object msg, Element def)  {
		String res = null;
		try {
			Document doc = null;
			if(msg instanceof ModelObject) {
				// Msg is an element as described in schema
				doc = this.getWsouiContext().marshallAnyElement(msg);
				res = XMLPrettyPrinter.prettyPrint(doc);
			} else if(
					msg instanceof GetResourcePropertyResponse ||
					msg instanceof Subscribe ||
					msg instanceof SubscribeResponse) {
				// Fix bug: ws-notification and ressource must be easyboxed
				doc = this.getWsouiContext().marshallAnyElement(msg);
				res = XMLPrettyPrinter.prettyPrint(doc);
			} else {
				doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();

				QName elmtName = new QName(SchemaHelper.findParentSchema(def).getTargetNamespace(), def.getName());
				Type t = def.findType();
				if(t instanceof ComplexType) {
					ComplexType ct = (ComplexType)t;
					if(ct.getSequence() != null && ct.getSequence().getElements().length == 1) {
						elmtName = ct.getSequence().getElements()[0].inferQName();
					} else if(ct.getAll() != null && ct.getAll().getElements().length == 1) {
						elmtName = ct.getAll().getElements()[0].inferQName();
					}  
				}

				org.w3c.dom.Element root = doc.createElementNS(elmtName.getNamespaceURI(), elmtName.getLocalPart());

				if(msg != null) {
					root.setNodeValue(msg.toString());
					doc.appendChild(root);
					res = XMLPrettyPrinter.prettyPrint(doc);
				} else {
					// create msg
					res = XSD2XML.newInstance().printXml(def,"?");
				}

			}
		} catch (ParserConfigurationException e) {
			// do nothing
			e.printStackTrace();
		} catch (WSOUIException e) {
			// do nothing
			e.printStackTrace();
		} 
		if(res != null) {
			// clean string
			res = res.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n", "");
		} else {
			LOG.warning("Impossible to convert into document, the objet: \n" + msg + "\n from this definition: " + def);
		}
		return res;
	}

	public WSOUIJaxbContextItf getWsouiContext() {
		return wsouiContext;
	}

	public void setWsouiContext(WSOUIJaxbContextItf wsouiContext) {
		this.wsouiContext = wsouiContext;
	}

	public Description getDescription() {
		return description;
	}



	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					new WSOUIProvider(null, null, null).setVisible(true);
				} catch (WSOUIException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});
	}




	private void listHandler(java.awt.event.MouseEvent evt) {                             
		this.responseType = (String) this.jListResponseType.getSelectedValue();
		updateExchangeInformations();
	}

	public void updateExchangeInformations(){
		setExchangeInformations(_serviceName, _endpointName, _operationName, _request, response, this.expectedReturnType, this.responseType);
	}


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonSendResponse;
    private javax.swing.JEditorPane jEditorPaneRequest;
    private javax.swing.JEditorPane jEditorPaneResponse;
    private javax.swing.JLabel jLabelEndpointName;
    private javax.swing.JLabel jLabelImage;
    private javax.swing.JLabel jLabelInterfaceQName;
    private javax.swing.JLabel jLabelOperationName;
    private javax.swing.JLabel jLabelResponseType;
    private javax.swing.JLabel jLabelServiceQName;
    private javax.swing.JList jListResponseType;
    private javax.swing.JPanel jPanelCommand;
    private javax.swing.JPanel jPanelImage;
    private javax.swing.JPanel jPanelMain;
    private javax.swing.JPanel jPanelRequest;
    private javax.swing.JPanel jPanelResponse;
    private javax.swing.JPanel jPanelServiceInformations;
    private javax.swing.JScrollPane jScrollPaneMain;
    private javax.swing.JScrollPane jScrollPaneRequest;
    private javax.swing.JScrollPane jScrollPaneResponse;
    private javax.swing.JScrollPane jScrollPaneResponseType;
    private javax.swing.JTextField jTextFieldEndpointName;
    private javax.swing.JTextField jTextFieldInterfaceQName;
    private javax.swing.JTextField jTextFieldOperationName;
    private javax.swing.JTextField jTextFieldServiceQName;
    // End of variables declaration//GEN-END:variables
}
