/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.util;

import com.ebmwebsourcing.easierbsm.BSMFactoryImpl;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbFault;
import easyesb.petalslink.com.data.admin._1.StoreBpel;
import easyesb.petalslink.com.data.admin._1.StoreBpelResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ESBManagement {
    private static ESBManagement esbManagement = new ESBManagement();
    private ESBFactory esbFactory = new ESBFactoryImpl(new String[0]);
    private ESBFactory monitoringFactory = new BSMFactoryImpl(new String[0]);

    public static ESBManagement getInstance() {
        return esbManagement;
    }

    private ESBManagement() {
    }

    public void setESBFactory(ESBFactory factory) {
        this.esbFactory = factory;
    }

    public ESBFactory getESBFactory() {
        return this.esbFactory;
    }

    public void setMonitoringFactory(ESBFactory factory) {
        this.monitoringFactory = factory;
    }

    public ESBFactory getMonitoringFactory() {
        return this.monitoringFactory;
    }

    public Node createBSMNode(QName name, String host, int port, final int soap_port) throws ESBException {
        BSMFactoryImpl factory = new BSMFactoryImpl(new String[]{"creation-resources-service-factory", "rawreport-service-factory"});
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        return node;
    }

    public Node createNode(QName name, String host, int port, final int soap_port) throws ESBException {
        ESBFactoryImpl factory = new ESBFactoryImpl(new String[]{"data-collector-factory", "wsdm-monitoring-factory", "sla-manager-factory"});
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        return node;
    }

    public List<URL> deployAndExposeBPEL(URL bpel, URL nodeUrl) throws ManagementException {
        ArrayList<URL> res = new ArrayList<URL>();
        try {
            StoreBpel payload = new StoreBpel();
            StoreBpelResponse storeBpelReponse = null;
            payload.setBpelUrl(bpel.toString());
            storeBpelReponse = ESBManagement.storeBpel(payload, nodeUrl.toString());
            for (String url : storeBpelReponse.getBpelEndpointAddress()) {
                res.add(new URL(url));
            }
        }
        catch (MalformedURLException e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
        return res;
    }

    private static StoreBpelResponse storeBpel(StoreBpel payload, String address) throws ManagementException {
        SOAPSender sender = new SOAPSender();
        SOAPHandler soapHandler = new SOAPHandler();
        StoreBpelResponse response = null;
        try {
            Document soapRequest = SOAPSender.createSOAPMessageRequest((Document)SOAJAXBContext.getInstance().unmarshallAnyElement((Object)payload));
            Document soapResponse = sender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/storeBpel");
            if (SOAPHandler.isSoapFault((Document)soapResponse)) {
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild(doc.importNode((Element)SOAPHandler.getFaultDetails((Document)soapResponse).get(0), true));
                EJaxbFault fault = (EJaxbFault)SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbFault.class);
                System.err.println("\n\nError message: \n" + fault.getMessage());
                System.err.println("Stack trace: \n" + fault.getStacktrace());
                throw new ManagementException("Business Fault", fault);
            }
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            doc.appendChild(doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody((Document)soapResponse)), true));
            response = (StoreBpelResponse)SOAJAXBContext.getInstance().marshallAnyType(doc, StoreBpelResponse.class);
        }
        catch (JDOMException e) {
            throw new ManagementException("Technical Fault");
        }
        catch (SOAException e) {
            throw new ManagementException("Technical Fault");
        }
        catch (SOAPException e) {
            throw new ManagementException("Technical Fault");
        }
        catch (ParserConfigurationException e) {
            throw new ManagementException("Technical Fault");
        }
        return response;
    }
}

