package org.petalslink.easiestdemo.wsoui.provided.notification;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.jaxb.notification.base.Notify;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Subscribe;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.TopicExpressionType;
import com.ebmwebsourcing.wsstar.jaxb.notification.topics.TopicSetType;

public class FixCxfBug {

	private List<TopicSetType> topicSets = new ArrayList<TopicSetType>();

	private static FixCxfBug INSTANCE;

	private FixCxfBug() {

	}

	public static FixCxfBug getInstance() {
		if(INSTANCE == null) {
			INSTANCE = new FixCxfBug();
		}
		return INSTANCE;
	}

	public void addTopicSet(TopicSetType tps) {
		this.topicSets.add(tps);
	}

	public String getTopic(Subscribe sub) {
		String res = null;
		System.out.println("sub.getFilter().getAny() = " + sub.getFilter().getAny());
		System.out.println("sub.getFilter().getAny().get(0) = " + sub.getFilter().getAny().get(0));
		System.out.println();
		JAXBElement elmt = (JAXBElement) sub.getFilter().getAny().get(0);
		System.out.println("elmt.value = " + elmt.getValue());
		TopicExpressionType topicExp = (TopicExpressionType) elmt.getValue();
		res = (String) topicExp.getContent().get(0);
		return res;
	}

	public String getTopic(Notify not) {
		String res = null;
		res = (String) not.getNotificationMessage().get(0).getTopic().getContent().get(0);
		return res;
	}

	public void addNamespacetoTopicInSubscribe(Subscribe sub) {
		JAXBElement elmt = (JAXBElement) sub.getFilter().getAny().get(0);
		System.out.println("elmt.value = " + elmt.getValue());
		TopicExpressionType topicExp = (TopicExpressionType) elmt.getValue();
		String content = getTopic(sub);
		String prefix = content.split(":")[0];
		String localpart = content.split(":")[1];
		System.out.println("content = " + content);
		System.out.println("prefix = " + prefix);
		System.out.println("localpart = " + localpart);
		for(TopicSetType tps: this.topicSets) {
			for(Object o: tps.getAny()) {
				if(o instanceof Element) {
					Element e = (Element) o;
					System.out.println("e = " + e.getLocalName());
					System.out.println("e = " + e.getNamespaceURI());
					if(e.getLocalName().equals(localpart)) {
						System.out.println("FOUND NS");
						topicExp.getOtherAttributes().put(new QName("http://www.w3.org/XML/1998/namespace", prefix), e.getNamespaceURI());
						break;
					}
				}
			}
		}
	}

	public void addNamespacetoTopicInNotify(Notify notify, QName topicQn) {
		String content = getTopic(notify);
		String prefix = content.split(":")[0];
		String localpart = content.split(":")[1];
		System.out.println("content = " + content);
		System.out.println("prefix = " + prefix);
		System.out.println("localpart = " + localpart);
		notify.getNotificationMessage().get(0).getTopic().getOtherAttributes().put(new QName("http://www.w3.org/XML/1998/namespace", topicQn.getPrefix()), topicQn.getNamespaceURI());
	}
}
