/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.sdk.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class JPanelImageBg
extends JComponent {
    private static final long serialVersionUID = 1L;
    private int mode;
    private TexturePaint texture;
    private BufferedImage bufferedImage;
    public static final int CENTRE = 0;
    public static final int TEXTURE = 1;

    public JPanelImageBg(URL fileName, int mode) {
        this.mode = mode;
        this.bufferedImage = this.toBufferedImage(Toolkit.getDefaultToolkit().getImage(fileName));
        this.texture = new TexturePaint(this.bufferedImage, new Rectangle(0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight()));
    }

    public JPanelImageBg(Image img) {
        this.mode = 0;
        this.bufferedImage = this.toBufferedImage(img);
        this.texture = new TexturePaint(this.bufferedImage, new Rectangle(0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight()));
    }

    @Override
    public void paintComponent(Graphics g) {
        switch (this.mode) {
            case 1: {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(this.texture);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                break;
            }
            case 0: {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.drawImage(this.bufferedImage, (this.getWidth() - this.bufferedImage.getWidth()) / 2, (this.getHeight() - this.bufferedImage.getHeight()) / 2, null);
                break;
            }
            default: {
                super.paintComponents(g);
            }
        }
    }

    private BufferedImage toBufferedImage(Image image) {
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, image.getWidth(null), image.getHeight(null));
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufferedImage;
    }

    public static BufferedImage scale(BufferedImage bi, double scaleValue) {
        AffineTransform tx = new AffineTransform();
        tx.scale(scaleValue, scaleValue);
        AffineTransformOp op = new AffineTransformOp(tx, 2);
        BufferedImage biNew = new BufferedImage((int)((double)bi.getWidth() * scaleValue), (int)((double)bi.getHeight() * scaleValue), bi.getType());
        return op.filter(bi, biNew);
    }

    public static Image scale(Image source, int width, int height) {
        BufferedImage buf = new BufferedImage(width, height, 2);
        Graphics2D g = buf.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(source, 0, 0, width, height, null);
        g.dispose();
        return buf;
    }
}

