package org.petalslink.easiestdemo.sdk;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Map;

public class ThreadRun extends Thread {

	private PrintStream ps;

	private File startAllScript = null;

	public ThreadRun(File startAllScript, PrintStream ps) {
		this.ps = ps;
		this.startAllScript = startAllScript;
	}

	@Override
	public void run() {
		try {
			//	ProcessBuilder pb = new ProcessBuilder("./StartAll.bat");
			ProcessBuilder pb = new ProcessBuilder(new String(startAllScript.getAbsolutePath().toString()).replace("..", ""));
			pb.redirectErrorStream(true);
			Map<String, String> env = pb.environment();

			pb.directory(startAllScript.getParentFile());
			Process p = pb.start();

			if(ps == null) {
				ps = System.out;
			}

			writeInputStream(p.getInputStream(), ps);

			writeInputStream(p.getErrorStream(), ps); 


			p.exitValue();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 
	}

	private void writeInputStream(InputStream ips, PrintStream ps) throws IOException {
		InputStreamReader ipsr=new InputStreamReader(ips);
		BufferedReader br=new BufferedReader(ipsr);
		String ligne;
		while ((ligne=br.readLine())!=null){
			System.out.println(ligne);
			System.out.flush();
		}
		br.close();
	}
}
