package org.petalslink.easiestdemo.sdk.core;


import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;

import com.ebmwebsourcing.easycommons.uri.URIHelper;



public class BPELGenerator {

	private String tns;
	private String bpelProcessName;


	public BPELGenerator(String tns, String bpelProcessName) {
		this.tns = tns;
		this.bpelProcessName = bpelProcessName;
	}


	public File generate(String bpelUrl, String fileName) throws IOException {
		File f = new File(bpelUrl + "/" + fileName);
		FileWriter writer = null;
		try {
			writer = new FileWriter(f);
			
			
			
			writer.write("<!-- " + this.bpelProcessName + " BPEL Process [Generated by the EasiestDEMO SDK] -->\r\n" + 
					"<!-- Date: Fri Jan 28 16:48:34 CET 2011 -->\r\n" + 
					"<bpel:process name=\"" + this.bpelProcessName + "\" targetNamespace=\"" + this.tns + "\"\r\n" + 
					"	suppressJoinFailure=\"yes\" xmlns:tns=\"" + this.tns + "\"\r\n" + 
					"	xmlns:bpel=\"http://docs.oasis-open.org/wsbpel/2.0/process/executable\">\r\n" + 
					"\r\n" + 
					"	<!-- Import the client WSDL -->\r\n" + 
					"	<bpel:import location=\"" + this.bpelProcessName + ".wsdl\" namespace=\"" + this.tns + "\"\r\n" + 
					"		importType=\"http://schemas.xmlsoap.org/wsdl/\" />\r\n" + 
					"\r\n" + 
					"	<!-- ================================================================= -->\r\n" + 
					"	<!-- PARTNERLINKS -->\r\n" + 
					"	<!-- List of services participating in this BPEL process -->\r\n" + 
					"	<!-- ================================================================= -->\r\n" + 
					"	<bpel:partnerLinks>\r\n" + 
					"		<!-- The 'client' role represents the requester of this service. -->\r\n" + 
					"		<bpel:partnerLink name=\"client\" partnerLinkType=\"tns:" + this.bpelProcessName + "\"\r\n" + 
					"			myRole=\"" + this.bpelProcessName + "Provider\" />\r\n" + 
					"	</bpel:partnerLinks>\r\n" + 
					"\r\n" + 
					"	<!-- ================================================================= -->\r\n" + 
					"	<!-- VARIABLES -->\r\n" + 
					"	<!-- List of messages and XML documents used within this BPEL process -->\r\n" + 
					"	<!-- ================================================================= -->\r\n" + 
					"	<bpel:variables>\r\n" + 
					"		<!-- Reference to the message passed as input during initiation -->\r\n" + 
					"		<bpel:variable name=\"input\" messageType=\"tns:" + this.bpelProcessName + "RequestMessage\" />\r\n" + 
					"\r\n" + 
					"		<!-- Reference to the message that will be returned to the requester -->\r\n" + 
					"		<bpel:variable name=\"output\" messageType=\"tns:" + this.bpelProcessName + "ResponseMessage\" />\r\n" + 
					"	</bpel:variables>\r\n" + 
					"\r\n" + 
					"	<!-- ================================================================= -->\r\n" + 
					"	<!-- ORCHESTRATION LOGIC -->\r\n" + 
					"	<!-- Set of activities coordinating the flow of messages across the -->\r\n" + 
					"	<!-- services integrated within this business process -->\r\n" + 
					"	<!-- ================================================================= -->\r\n" + 
					"	<bpel:sequence name=\"main\">\r\n" + 
					"\r\n" + 
					"		<!-- Receive input from requester. Note: This maps to operation defined \r\n" + 
					"			in " + this.bpelProcessName + ".wsdl -->\r\n" + 
					"		<bpel:receive name=\"receiveInput\" partnerLink=\"client\"\r\n" + 
					"			portType=\"tns:" + this.bpelProcessName + "\" operation=\"process\" variable=\"input\"\r\n" + 
					"			createInstance=\"yes\" />\r\n" + 
					"        \r\n" + 
					"        <!-- Generate reply to synchronous request -->\r\n" + 
					"        <bpel:assign validate=\"no\" name=\"Assign\">\r\n" + 
					"            <bpel:copy>\r\n" + 
					"                <bpel:from>\r\n" + 
					"                  <bpel:literal>\r\n" + 
					"       	            <tns:" + this.bpelProcessName + "Response xmlns:tns=\"" + this.tns + "\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n" + 
					"                      <tns:result>tns:result</tns:result>\r\n" + 
					"                    </tns:" + this.bpelProcessName + "Response>\r\n" + 
					"                  </bpel:literal>\r\n" + 
					"                </bpel:from>\r\n" + 
					"                <bpel:to variable=\"output\" part=\"payload\"></bpel:to>\r\n" + 
					"            </bpel:copy>\r\n" + 
					"            <bpel:copy>\r\n" + 
					"                <bpel:from part=\"payload\" variable=\"input\">\r\n" + 
					"                    <bpel:query queryLanguage=\"urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0\"><![CDATA[tns:input]]></bpel:query>\r\n" + 
					"                </bpel:from>\r\n" + 
					"                <bpel:to part=\"payload\" variable=\"output\">\r\n" + 
					"                    <bpel:query queryLanguage=\"urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0\"><![CDATA[tns:result]]></bpel:query>\r\n" + 
					"                </bpel:to>\r\n" + 
					"            </bpel:copy>\r\n" + 
					"        </bpel:assign>\r\n" + 
					"        <bpel:reply name=\"replyOutput\" \r\n" + 
					"               partnerLink=\"client\"\r\n" + 
					"               portType=\"tns:" + this.bpelProcessName + "\"\r\n" + 
					"               operation=\"process\" \r\n" + 
					"               variable=\"output\"\r\n" + 
					"               />\r\n" + 
					"    </bpel:sequence>\r\n" + 
					"</bpel:process>\r\n" + 
					"\r\n" + 
					"");
		} finally{
			if(writer != null){
				writer.close();
			}
		}

		return f;
	}
}
