package org.petalslink.easiestdemo.sdk;

import java.io.File;

import javax.xml.namespace.QName;

public class TaskCreateBpelProject extends Task {

	private QName bpelProcess;

	private CommandOut cmd;

	public TaskCreateBpelProject(QName bpelProcess, CommandOut cmd) {
		this.bpelProcess = bpelProcess;
		this.cmd = cmd;

		if(this.cmd == null) {
			this.cmd = new CommandOut(new File(".").toString());
		}
	}

	@Override
	public void execute() throws SDKException {
		SDKService service = new SDKService();
		service.createNewProject(bpelProcess.getNamespaceURI(), bpelProcess.getLocalPart(), new File(cmd.getValue()), true);

		String result = "" +
		"BPEL Maven project has been created at " + cmd.getValue() + "/" + bpelProcess.getLocalPart().toLowerCase() + "\n" +
		"You can import your project in eclipse using easiest-eclipse in bpel project directory\n" +
		"or compile bpel using easiest-compile in bpel project directory\n" + 
		"or package bpel using easiest-package in bpel project directory\n";
		
		this.setResult(result);
	}
}
