/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.sdk.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class POMGenerator {
    private String groupId;
    private String artefactId;
    private String version;
    private String bpelProcessName;
    private Logger log = Logger.getLogger(this.getClass().getCanonicalName());

    public POMGenerator(String groupId, String artefactId, String version, String bpelProcessName) {
        this.groupId = groupId;
        this.artefactId = artefactId;
        this.version = version;
        this.bpelProcessName = bpelProcessName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generate(String bpelUrl, String basedir) throws IOException, Exception {
        File f = new File(bpelUrl + "/" + basedir + "/pom.xml");
        FileWriter writer = null;
        String mavenWsouiPluginVersion = this.getVersionInInitSDKPropertiesFile();
        if (mavenWsouiPluginVersion == null) {
            throw new Exception("The mavenWsouiPluginVersion cannot be null!!!");
        }
        try {
            writer = new FileWriter(f);
            writer.write("<?xml version=\"1.0\"?>\n");
            writer.write("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            writer.write("       xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n");
            writer.write("\t\t<modelVersion>4.0.0</modelVersion>\n");
            writer.write("\t\t<name>" + this.artefactId + "</name>\n");
            writer.write("\t\t<artifactId>" + this.artefactId + "</artifactId>\n");
            writer.write("\t\t<groupId>" + this.groupId + "</groupId>\n");
            writer.write("\t\t<version>" + this.version + "</version>\n");
            writer.write("\t\t<packaging>jar</packaging>\n");
            writer.write("\t\t<dependencies>\n");
            writer.write("\t\t\t<dependency>\n");
            writer.write("\t\t\t\t<groupId>com.ebmwebsourcing.easiestdemo</groupId>\n");
            writer.write("\t\t\t\t<artifactId>maven-wsoui-plugin</artifactId>\n");
            writer.write("\t\t\t\t<version>" + mavenWsouiPluginVersion + "</version>\n");
            writer.write("\t\t\t</dependency>\n");
            writer.write("\t\t\t<dependency>\n");
            writer.write("\t\t\t\t<groupId>com.ebmwebsourcing.easiestdemo</groupId>\n");
            writer.write("\t\t\t\t<artifactId>easiestdemo-helper</artifactId>\n");
            writer.write("\t\t\t\t<version>" + mavenWsouiPluginVersion + "</version>\n");
            writer.write("\t\t\t</dependency>\n");
            writer.write("\t\t</dependencies>\n");
            writer.write("\t\t\t<build>\n");
            writer.write("\t\t\t\t<plugins>\n");
            writer.write("\t\t\t\t\t<plugin>\n");
            writer.write("\t\t\t\t\t\t<groupId>com.ebmwebsourcing.easiestdemo</groupId>\n");
            writer.write("\t\t\t\t\t\t<artifactId>maven-wsoui-plugin</artifactId>\n");
            writer.write("\t\t\t\t\t\t<version>" + mavenWsouiPluginVersion + "</version>\n");
            writer.write("\t\t\t\t\t\t<dependencies>\n");
            writer.write("\t\t\t\t\t\t\t<dependency>\n");
            writer.write("\t\t\t\t\t\t\t\t<groupId>org.apache.neethi</groupId>\n");
            writer.write("\t\t\t\t\t\t\t\t<artifactId>neethi</artifactId>\n");
            writer.write("\t\t\t\t\t\t\t\t<version>3.0.2</version>\n");
            writer.write("\t\t\t\t\t\t\t</dependency>\n");
            writer.write("\t\t\t\t\t\t</dependencies>\n");
            writer.write("\t\t\t\t\t\t<executions>\n");
            writer.write("\t\t\t\t\t\t\t<execution>\n");
            writer.write("\t\t\t\t\t\t\t\t<id>generate-sources</id>\n");
            writer.write("\t\t\t\t\t\t\t\t<phase>generate-sources</phase>\n");
            writer.write("\t\t\t\t\t\t\t\t<configuration>\n");
            writer.write("\t\t\t\t\t\t\t\t\t<bpelOptions>\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t<bpelOption>\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t\t<bpel>${basedir}/src/main/resources/" + this.bpelProcessName + ".bpel</bpel>\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t\t<overrideOlderBusinessClass>true</overrideOlderBusinessClass>\n");
            writer.write("\t\t\t\t\t\t\t\t\t</bpelOption>\n");
            writer.write("\t\t\t\t\t\t\t\t\t</bpelOptions>\n");
            writer.write("\t\t\t\t\t\t\t\t</configuration>\n");
            writer.write("\t\t\t\t\t\t\t\t<goals>\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t\t<goal>bpel2java</goal>\n");
            writer.write("\t\t\t\t\t\t\t\t</goals>\n");
            writer.write("\t\t\t\t\t\t\t</execution>\n");
            writer.write("\t\t\t\t\t\t</executions>\n");
            writer.write("\t\t\t\t\t</plugin>\n");
            writer.write("<plugin>\r\n\t\t\t\t<groupId>org.apache.maven.plugins</groupId>\r\n\t\t\t\t<artifactId>maven-dependency-plugin</artifactId>\r\n\t\t\t\t<executions>\r\n\t\t\t\t\t<execution>\r\n\t\t\t\t\t\t<id>unpack-assembly</id>\r\n\t\t\t\t\t\t<phase>process-resources</phase>\r\n\t\t\t\t\t\t<goals>\r\n\t\t\t\t\t\t\t<goal>unpack</goal>\r\n\t\t\t\t\t\t</goals>\r\n\t\t\t\t\t\t<configuration>\r\n\t\t\t\t\t\t\t<artifactItems>\r\n\t\t\t\t\t\t\t\t<artifactItem>\r\n\t\t\t\t\t\t\t\t\t<groupId>com.ebmwebsourcing.easiestdemo</groupId>\r\n\t\t\t\t\t\t\t\t\t<artifactId>maven-wsoui-plugin</artifactId>\r\n\t\t\t\t\t\t\t\t\t<type>jar</type>\r\n\t\t\t\t\t\t\t\t\t<outputDirectory>${project.build.directory}</outputDirectory>\r\n\t\t\t\t\t\t\t\t\t<includes>assembly/**/*</includes>\r\n\t\t\t\t\t\t\t\t</artifactItem>\r\n\t\t\t\t\t\t\t</artifactItems>\r\n\t\t\t\t\t\t</configuration>\r\n\t\t\t\t\t</execution>\r\n\t\t\t\t</executions>\r\n\t\t\t</plugin>");
            writer.write(" <!-- FIXME: Add cxf catalog to avoid to duplicate class -->\r\n      <plugin>\r\n        <artifactId>maven-antrun-plugin</artifactId>\r\n        <executions>\r\n          <execution>\r\n            <id>delete-duplicate-classes</id>\r\n            <phase>process-resources</phase>\r\n            <goals>\r\n              <goal>run</goal>\r\n            </goals>\r\n            <configuration>\r\n              <tasks>\r\n                <echo message=\"delete duplicate classes\"/>\r\n                <delete dir=\"./target/generated-sources/wsoui/easybox\"/>\r\n                <delete dir=\"./target/classes/easybox\"/>\r\n                <delete dir=\"./target/generated-sources/wsoui/esstar\"/>\r\n                <delete dir=\"./target/classes/esstar\"/>\r\n              </tasks>\r\n            </configuration>\r\n          </execution>\r\n        </executions>\r\n      </plugin>");
            writer.write("\t\t\t\t\t<plugin>\n");
            writer.write("\t\t\t\t\t\t<groupId>org.apache.maven.plugins</groupId>\n");
            writer.write("\t\t\t\t\t\t<artifactId>maven-jar-plugin</artifactId>\n");
            writer.write("\t\t\t\t\t\t\t<configuration>\n");
            writer.write("\t\t\t\t\t\t\t\t<finalName>server</finalName>\n");
            writer.write("\t\t\t\t\t\t\t\t<archive>\n");
            writer.write("\t\t\t\t\t\t\t\t\t<manifest>\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t\t<addClasspath>true</addClasspath>\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t</manifest>\n");
            writer.write("\t\t\t\t\t\t\t\t</archive>\n");
            writer.write("\t\t\t\t\t\t\t\t</configuration>\n");
            writer.write("\t\t\t\t\t</plugin>\n");
            writer.write("\t\t\t\t\t<plugin>\n");
            writer.write("\t\t\t\t\t\t<groupId>org.apache.maven.plugins</groupId>\n");
            writer.write("\t\t\t\t\t\t\t<artifactId>maven-assembly-plugin</artifactId>\n");
            writer.write("\t\t\t\t\t\t\t<executions>\n");
            writer.write("\t\t\t\t\t\t\t\t<execution>\n");
            writer.write("\t\t\t\t\t\t\t\t<id>dev-assembly</id>\n");
            writer.write("\t\t\t\t\t\t\t\t<configuration>\n");
            writer.write("\t\t\t\t\t\t\t\t\t<appendAssemblyId>false</appendAssemblyId>\n");
            writer.write("\t\t\t\t\t\t\t\t\t<attach>false</attach>\n");
            writer.write("\t\t\t\t\t\t\t\t\t<descriptors>\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t<descriptor>\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t\ttarget/assembly/dev.xml\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t</descriptor>\n");
            writer.write("\t\t\t\t\t\t\t\t\t</descriptors>\n");
            writer.write("\t\t\t\t\t\t\t\t</configuration>\n");
            writer.write("\t\t\t\t\t\t\t\t<phase>package</phase>\n");
            writer.write("\t\t\t\t\t\t\t\t<goals>\n");
            writer.write("\t\t\t\t\t\t\t\t\t<goal>attached</goal>\n");
            writer.write("\t\t\t\t\t\t\t\t</goals>\n");
            writer.write("\t\t\t\t\t\t\t\t</execution>\n");
            writer.write("<execution>\r\n\t\t\t\t\t\t<id>rsc-assembly</id>\r\n\t\t\t\t\t\t<configuration>\r\n\t\t\t\t\t\t\t<appendAssemblyId>true</appendAssemblyId>\r\n\t\t\t\t\t\t\t<descriptors>\r\n\t\t\t\t\t\t\t\t<descriptor>\r\n\t\t\t\t\t\t\t\t\ttarget/assembly/zip.xml\r\n\t\t\t\t\t\t\t\t</descriptor>\r\n\t\t\t\t\t\t\t</descriptors>\r\n\t\t\t\t\t\t</configuration>\r\n\t\t\t\t\t\t<phase>package</phase>\r\n\t\t\t\t\t\t<goals>\r\n\t\t\t\t\t\t\t<goal>attached</goal>\r\n\t\t\t\t\t\t</goals>\r\n\t\t\t\t\t</execution>");
            writer.write("\t\t\t\t\t\t</executions>\n");
            writer.write("\t\t\t\t\t</plugin>\n");
            writer.write("\t\t\t\t\t<plugin>\n");
            writer.write("\t\t\t\t\t\t<groupId>org.apache.maven.plugins</groupId>\n");
            writer.write("\t\t\t\t\t\t<artifactId>maven-compiler-plugin</artifactId>\n");
            writer.write("\t\t\t\t\t\t<configuration>\n");
            writer.write("\t\t\t\t\t\t\t<source>1.6</source>\n");
            writer.write("\t\t\t\t\t\t\t<target>1.6</target>\n");
            writer.write("\t\t\t\t\t\t\t<showDeprecation>true</showDeprecation>\n");
            writer.write("\t\t\t\t\t\t</configuration>\n");
            writer.write("\t\t\t\t\t</plugin>\n");
            writer.write("\t\t\t\t</plugins>\n");
            writer.write("\t\t\t</build>\n");
            writer.write("\t\t<repositories>\n");
            writer.write("\t\t\t<repository>\n");
            writer.write("\t\t\t\t<id>ebmws-research-public.release</id>\n");
            writer.write("\t\t\t\t<url>http://maven.petalslink.com/public-research</url>\n");
            writer.write("\t\t\t\t<releases>\n");
            writer.write("\t\t\t\t\t<enabled>true</enabled>\n");
            writer.write("\t\t\t\t</releases>\n");
            writer.write("\t\t\t\t<snapshots>\n");
            writer.write("\t\t\t\t\t<enabled>false</enabled>\n");
            writer.write("\t\t\t\t</snapshots>\n");
            writer.write("\t\t\t</repository>\n");
            writer.write("\t\t\t<repository>\n");
            writer.write("\t\t\t\t<id>ebmws-public.release</id>\n");
            writer.write("\t\t\t\t<url>http://maven.petalslink.com/public</url>\n");
            writer.write("\t\t\t\t<releases>\n");
            writer.write("\t\t\t\t\t<enabled>true</enabled>\n");
            writer.write("\t\t\t\t</releases>\n");
            writer.write("\t\t\t\t<snapshots>\n");
            writer.write("\t\t\t\t\t<enabled>false</enabled>\n");
            writer.write("\t\t\t\t</snapshots>\n");
            writer.write("\t\t\t</repository>\n");
            writer.write("\t\t\t<repository>\n");
            writer.write("\t\t\t\t<id>ebmws-public.snapshot</id>\n");
            writer.write("\t\t\t\t<url>http://maven.petalslink.com/public-snapshot</url>\n");
            writer.write("\t\t\t\t<releases>\n");
            writer.write("\t\t\t\t\t<enabled>false</enabled>\n");
            writer.write("\t\t\t\t</releases>\n");
            writer.write("\t\t\t\t<snapshots>\n");
            writer.write("\t\t\t\t\t<enabled>true</enabled>\n");
            writer.write("\t\t\t\t</snapshots>\n");
            writer.write("\t\t\t</repository>\n");
            writer.write("\t\t\t<repository>\n");
            writer.write("\t\t\t\t<id>ebmws-others</id>\n");
            writer.write("\t\t\t\t<url>http://maven.petalslink.com/others</url>\n");
            writer.write("\t\t\t\t<releases>\n");
            writer.write("\t\t\t\t\t<enabled>true</enabled>\n");
            writer.write("\t\t\t\t</releases>\n");
            writer.write("\t\t\t\t<snapshots>\n");
            writer.write("\t\t\t\t\t<enabled>false</enabled>\n");
            writer.write("\t\t\t\t</snapshots>\n");
            writer.write("\t\t\t</repository>\n");
            writer.write("\t\t</repositories>\n");
            writer.write("\t\t<pluginRepositories>\n");
            writer.write("\t\t\t\t<pluginRepository>\n");
            writer.write("\t\t\t\t\t<id>ebmws-research-public.release</id>\n");
            writer.write("\t\t\t\t\t<url>http://maven.petalslink.com/public-research</url>\n");
            writer.write("\t\t\t\t\t<releases>\n");
            writer.write("\t\t\t\t\t<enabled>true</enabled>\n");
            writer.write("\t\t\t\t\t</releases>\n");
            writer.write("\t\t\t\t\t<snapshots>\n");
            writer.write("\t\t\t\t\t<enabled>false</enabled>\n");
            writer.write("\t\t\t\t\t</snapshots>\n");
            writer.write("\t\t\t\t</pluginRepository>\n");
            writer.write("\t\t\t\t<pluginRepository>\n");
            writer.write("\t\t\t\t\t<id>ebmws-public.release</id>\n");
            writer.write("\t\t\t\t\t<url>http://maven.petalslink.com/public</url>\n");
            writer.write("\t\t\t\t\t<releases>\n");
            writer.write("\t\t\t\t\t\t<enabled>true</enabled>\n");
            writer.write("\t\t\t\t</releases>\n");
            writer.write("\t\t\t\t<snapshots>\n");
            writer.write("\t\t\t\t\t<enabled>false</enabled>\n");
            writer.write("\t\t\t\t</snapshots>\n");
            writer.write("\t\t\t\t</pluginRepository>\n");
            writer.write("\t\t\t<pluginRepository>\n");
            writer.write("\t\t\t\t<id>ebmws-public.snapshot</id>\n");
            writer.write("\t\t\t\t<url>http://maven.petalslink.com/public-snapshot</url>\n");
            writer.write("\t\t\t\t<releases>\n");
            writer.write("\t\t\t\t\t<enabled>false</enabled>\n");
            writer.write("\t\t\t\t</releases>\n");
            writer.write("\t\t\t\t<snapshots>\n");
            writer.write("\t\t\t\t\t<enabled>true</enabled>\n");
            writer.write("\t\t\t\t</snapshots>\n");
            writer.write("\t\t\t</pluginRepository>\n");
            writer.write("\t\t\t<pluginRepository>\n");
            writer.write("\t\t\t\t<id>ebmws-others</id>\n");
            writer.write("\t\t\t\t<url>http://maven.petalslink.com/others</url>\n");
            writer.write("\t\t\t\t<releases>\n");
            writer.write("\t\t\t\t\t<enabled>true</enabled>\n");
            writer.write("\t\t\t\t</releases>\n");
            writer.write("\t\t\t\t<snapshots>\n");
            writer.write("\t\t\t\t\t<enabled>false</enabled>\n");
            writer.write("\t\t\t\t</snapshots>\n");
            writer.write("\t\t\t</pluginRepository>\n");
            writer.write("\t\t</pluginRepositories>\n");
            writer.write("</project>\n");
            writer.write("");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return f;
    }

    public String getVersionInInitSDKPropertiesFile() throws IOException {
        Properties props = new Properties();
        props.load(Thread.currentThread().getContextClassLoader().getResource("initSDK.properties").openStream());
        return (String)props.get("sdk.version");
    }
}

