/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.api.type;

import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Assignment;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Expression;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.ItemAwareElement;

public interface TDataAssociation extends TBaseElement {

	ItemAwareElement[] getSourceRef();
	
	void addSourceRef(ItemAwareElement iae);
	
	void removeSourceRef(ItemAwareElement iae);
	
	boolean hasSourceRef();

	void unsetSourceRef();

	ItemAwareElement getTargetRef();
	
	void setTargetRef(ItemAwareElement iae);

	boolean hasTargetRef();
	
	Expression getTransformation();

	void setTransformation(Expression value);

	boolean hasTransformation();

	Assignment[] getAssignment();
	
	void addAssignment(Assignment a);
	
	void removeAssignment(Assignment a);

	boolean hasAssignment();

	void unsetAssignment();

}
