/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.api.type;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easyschema10.api.element.Schema;

public interface TImport extends XmlObject {
	String getNamespace();

	void setNamespace(String value);

	boolean hasNamespace();

	String getLocation();

	void setLocation(String value);

	boolean hasLocation();

	String getImportType();

	void setImportType(String value);

	boolean hasImportType();
	
	boolean isWSDL20Import();
	
	boolean isBPMN20Import();
	
	boolean isXSDImport();
	
	boolean isWSDL11Import();
	
	/**
	 * Facility to store the actual content of the file referenced by this import.
	 * Calling this method will not modify the XML model object. 
	 */
	void setImportContent(XmlObject content);
	
	Schema getSchema();
	
	Definitions getBPMNDefinitions();
	
	com.ebmwebsourcing.easywsdl11.api.element.Definitions getWSDL11Definitions();

    XmlObject getImportContent();
	
	//TODO WSDL20 : Description getWSDL20Description() throws BPMNException;
	
}
