/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Expression;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ImplicitThrowEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TComplexBehaviorDefinition;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTComplexBehaviorDefinition;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTFormalExpression;

class TComplexBehaviorDefinitionImpl extends AbstractTBaseElementImpl<EJaxbTComplexBehaviorDefinition> implements
TComplexBehaviorDefinition {

	protected TComplexBehaviorDefinitionImpl(XmlContext xmlContext,
			EJaxbTComplexBehaviorDefinition jaxbModel) {
		super(xmlContext, jaxbModel);

	}

	@Override
	public Expression getCondition() {
		return this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getCondition(),ExpressionImpl.class);
	}

	@Override
	public void setCondition(Expression value) {
		this.getModelObject().setCondition((EJaxbTFormalExpression)((ExpressionImpl)value).getModelObject());
	}

	@Override
	public boolean hasCondition() {
		return this.getModelObject().isSetCondition();
	}

	@Override
	public ImplicitThrowEvent getEvent() {
		return this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getEvent(),ImplicitThrowEventImpl.class);
	}

	@Override
	public void setEvent(ImplicitThrowEvent value) {
		this.getModelObject().setEvent(((ImplicitThrowEventImpl)value).getModelObject());
	}

	@Override
	public boolean hasEvent() {
		return this.getModelObject().isSetEvent();
	}

	@Override
	protected Class<? extends EJaxbTComplexBehaviorDefinition> getCompliantModelClass() {
		return EJaxbTComplexBehaviorDefinition.class;
	}

}
