/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.namespace.QName;

import org.w3c.dom.Attr;
import org.w3c.dom.Node;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Choreography;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Collaboration;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataStore;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EndPoint;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Error;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Escalation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Extension;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ItemDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Message;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.PartnerEntity;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.PartnerRole;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Process;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.RelationShip;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.RootElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Signal;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TDefinitions;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNDiagram;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;

import easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.EJaxbBPMNDiagram;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTChoreography;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTDataStore;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTDefinitions;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTEndPoint;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTError;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTEscalation;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTExtension;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTImport;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTInterface;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTItemDefinition;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTMessage;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTPartnerEntity;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTPartnerRole;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTProcess;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTRelationship;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTRootElement;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTSignal;

public class TDefinitionsImpl extends AbstractJaxbXmlObjectImpl<EJaxbTDefinitions>
		implements TDefinitions {

	protected TDefinitionsImpl(XmlContext xmlContext, EJaxbTDefinitions jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbTDefinitions> getCompliantModelClass() {
		return EJaxbTDefinitions.class;
	}
	
	
	
	@Override
	public Interface[] getInterfaces() {
		return createChildrenArray(getModelObject().getRootElement(), EJaxbTInterface.class, ANY_QNAME, Interface.class);
	}
	

	@Override
	public Import[] getImports() {
		return createChildrenArray(getModelObject().getImport(), EJaxbTImport.class, ANY_QNAME, ImportImpl.class);
	}
	
	@Override
    public Import getImport(String namespace) {
        for(Import i : getImports()) {
            if(i.hasNamespace() && i.getNamespace().equals(namespace)) {
                return i;
            }
        }
        return null;
    }

	@Override
	public boolean hasImport() {
		return this.getModelObject().isSetImport();
	}

	@Override
	public void unsetImport() {
		this.getModelObject().unsetImport();
	}
	
	@Override
	public void addImport(Import i){
		this.getModelObject().getImport().add(((ImportImpl)i).getModelObject());
	}
	  
	@Override
	public void removeImport(Import i){
		removeFromChildren(this.getModelObject().getImport(), i);
	}

	@Override
	public Element findImportedElement(QName eltQName) throws BPMNException{
	    if(eltQName==null){return null;}
	    return doFindImportedElement(eltQName, new HashSet<XmlObject>());
	}
	
	private Element doFindImportedElement(QName eltQName,Set<XmlObject> visited) throws BPMNException {
	    for(Import i : getImports()){
	        XmlObject content = i.getImportContent();
	        if(visited.contains(content)) {
	            continue;
	        }
	        else {
	            visited.add(content);
	        }
            if(i.isXSDImport()){
                Schema s = i.getSchema();
                if(s.getTargetNamespace().equals(eltQName.getNamespaceURI())){
                    Element e = s.getElementByName(eltQName.getLocalPart());
                    if(e!=null){
                        return e;
                    }
                }
            }
            else if(i.isWSDL11Import()){
                Element e = SchemaHelper.findElementByQName(i.getWSDL11Definitions(), eltQName);
                if(e!=null){
                    return e;
                }
            }
            else if(i.isBPMN20Import()){
                Element e = i.getBPMNDefinitions().findImportedElement(eltQName);
                if(e!=null){
                    return e;
                }
            }
        }
	    return null;
	}
	
	@Override
	public Map<String,String> findImportPrefixes() {
	    Map<String,String> result = new HashMap<String, String>();
	    if(hasImport()) {
	        Node defsNode = getXmlObjectDOMNode();
	        for(int i=0; i<defsNode.getAttributes().getLength(); i++) {
	            Attr attr = (Attr) defsNode.getAttributes().item(i);
	            if(attr.getName().startsWith("xmlns:")) {
	                Import impt = getImport(attr.getValue());
	                if(impt!=null) {
	                    String prefix = attr.getName().replace("xmlns:", "");
	                    result.put(impt.getNamespace(), prefix);
	                }
	            }
	        }
	    }
	    return result;
	}

	
	@Override
	public Extension[] getExtension() {
		return createChildrenArray(getModelObject()
	              .getExtension(), EJaxbTExtension.class, ANY_QNAME, 
	              ExtensionImpl.class);
	}

	@Override
	public boolean hasExtension() {
		return this.getModelObject().isSetExtension();
	}

	@Override
	public void unsetExtension() {
		this.getModelObject().unsetExtension();
	}
	
	@Override
	public void addExtension(Extension e) {
		addToChildren(getModelObject().getExtension(), e);
	}

	@Override
	public void removeExtension(Extension e) {
		removeFromChildren(getModelObject().getExtension(), e);
	}

	
	
	@Override
	public RootElement[] getRootElement() {
		XmlObject[] tab = createChildrenArray(getModelObject().getRootElement(), EJaxbTRootElement.class, ANY_QNAME);
		RootElement[] result = new RootElement[tab.length];
		for(int i=0; i<tab.length; i++){
			result[i] = (RootElement) tab[i];
		}
		return result;
	}

	@Override
	public boolean hasRootElement() {
		return this.getModelObject().isSetRootElement();
	}

	@Override
	public void unsetRootElement() {
		this.getModelObject().unsetRootElement();
	}

    @Override
    public void addRootElement(RootElement e){
        addToChildren(this.getModelObject().getRootElement(), e);
    }
      
    @Override
    public void removeRootElement(RootElement e){
        removeFromChildren(this.getModelObject().getRootElement(), e);
    }

	
	
	@Override
	public Process[] getProcesses(){
		return createChildrenArray(getModelObject().getRootElement(), EJaxbTProcess.class, ANY_QNAME, Process.class);
	}
	
	
	@Override
	public Collaboration[] getCollaborations(){
		List<Collaboration> l = new ArrayList<Collaboration>();
		for(RootElement re : getRootElement()){
			if((re instanceof Collaboration) && !(re instanceof Choreography)){
				l.add((Collaboration)re);
			}
		}
		Collaboration[] result = new Collaboration[l.size()];
		for(int i =0; i<l.size(); i++){
			result[i] = l.get(i);
		}
		return result;
	}
	   
	
	
	@Override
	public DataStore[] getDataStores(){
		return createChildrenArray(getModelObject().getRootElement(), EJaxbTDataStore.class, ANY_QNAME, DataStore.class);
	}
	   
	
	@Override
	public Choreography[] getChoreographies(){
		return createChildrenArray(getModelObject().getRootElement(), EJaxbTChoreography.class, ANY_QNAME, Choreography.class);
	}
	   
	
	@Override
    public EndPoint getEndPoint(QName qname) {
        String ns = qname.getNamespaceURI();
        if(ns==null || getTargetNamespace().equals(ns)){
            for(EndPoint ep : getEndPoints()){
                if(ep.getId().equals(qname.getLocalPart())){
                    return ep;
                }
            }
        }
        return null;
    }
	
	@Override
	public EndPoint[] getEndPoints(){
		return createChildrenArray(getModelObject().getRootElement(), EJaxbTEndPoint.class, ANY_QNAME, EndPoint.class);
	}
	
	
	@Override
	public Message[] getMessages(){
		return createChildrenArray(getModelObject().getRootElement(), EJaxbTMessage.class, ANY_QNAME, Message.class);
	}
	
	@Override
	public Message getMessage(String msgName) {
	    for(Message msg : getMessages()) {
	        if(msg.hasName() && msg.getName().equals(msgName)) {
	            return msg;
	        }
	    }
	    return null;
	}
	
	
	@Override
	public PartnerRole[] getPartnerRoles(){
		return createChildrenArray(getModelObject().getRootElement(), EJaxbTPartnerRole.class, ANY_QNAME, PartnerRole.class);
	}

	
	
	@Override
    public PartnerEntity[] getPartnerEntities(){
        return createChildrenArray(getModelObject().getRootElement(), EJaxbTPartnerEntity.class, ANY_QNAME, PartnerEntity.class);
    }
	
	
	
	@Override
	public ItemDefinition[] getItemDefinitions(){
		return createChildrenArray(getModelObject().getRootElement(), EJaxbTItemDefinition.class, ANY_QNAME, ItemDefinition.class);
	}
	
	
	
	@Override
    public Error[] getErrors(){
        return createChildrenArray(getModelObject().getRootElement(), EJaxbTError.class, ANY_QNAME, com.ebmwebsourcing.easybpmn.bpmn20.api.element.Error.class);
    }
	
	
	@Override
	public Escalation[] getEscalations() {
	    return createChildrenArray(getModelObject().getRootElement(), EJaxbTEscalation.class, ANY_QNAME, Escalation.class);
	}
	
	
    @Override
    public Signal[] getSignals(){
        return createChildrenArray(getModelObject().getRootElement(), EJaxbTSignal.class, ANY_QNAME, Signal.class);
    }
    
    
	
	@Override
	public BPMNDiagram[] getBPMNDiagram() {
		return createChildrenArray(getModelObject().getBPMNDiagram(), EJaxbBPMNDiagram.class, ANY_QNAME, BPMNDiagram.class);
	}

	@Override
	public boolean hasBPMNDiagram() {
		return this.getModelObject().isSetBPMNDiagram();
	}

	@Override
	public void unsetBPMNDiagram() {
		this.getModelObject().unsetBPMNDiagram();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void addBPMNDiagram(BPMNDiagram d){
		this.getModelObject().getBPMNDiagram().add((EJaxbBPMNDiagram)((AbstractXmlObjectImpl)d).getModelObject());
	}
	   
	@SuppressWarnings("unchecked")
	@Override
	public void removeBPMNDiagram(BPMNDiagram d){
		this.getModelObject().getBPMNDiagram().remove((EJaxbBPMNDiagram)((AbstractXmlObjectImpl)d).getModelObject());
	}

	
	
	@Override
	public RelationShip[] getRelationship() {
			return createChildrenArray(getModelObject()
	              .getRootElement(), EJaxbTRelationship.class, ANY_QNAME, 
	              RelationshipImpl.class);
	}

	@Override
	public boolean hasRelationship() {
		return this.getModelObject().isSetRelationship();
	}

	@Override
	public void unsetRelationship() {
		this.getModelObject().unsetRelationship();
	}

	
	
	@Override
	public String getId() {
		return this.getModelObject().getId();
	}

	@Override
	public void setId(String value) {
		this.getModelObject().setId(value);
	}

	@Override
	public boolean hasId() {
		return this.getModelObject().isSetId();
	}

	
	
	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);
	}

	@Override
	public boolean hasName() {
		return this.getModelObject().isSetName();
	}
	
	
	
	@Override
	public String getTargetNamespace(){
		return this.getModelObject().getTargetNamespace();
	}

	@Override
	public void setTargetNamespace(String value) {
		this.getModelObject().setTargetNamespace(value);
	}

	@Override
	public boolean hasTargetNamespace() {
		return this.getModelObject().isSetTargetNamespace();
	}

	
	
	@Override
	public String getExpressionLanguage() {
		return this.getModelObject().getExpressionLanguage();
	}

	@Override
	public void setExpressionLanguage(String value) {
		this.getModelObject().setExpressionLanguage(value);
	}

	@Override
	public boolean hasExpressionLanguage() {
		return this.getModelObject().isSetExpressionLanguage();
	}

	
	
	@Override
	public String getTypeLanguage() {
		return this.getModelObject().getTypeLanguage();
	}
	
	@Override
	public void setTypeLanguage(String value) {
		this.getModelObject().setTypeLanguage(value);
	}

	@Override
	public boolean hasTypeLanguage() {
		return this.getModelObject().isSetTypeLanguage();
	}

	
	
	@Override
	public String getExporter() {
		return this.getModelObject().getExporter();
	}

	@Override
	public void setExporter(String value) {
		this.getModelObject().setExporter(value);
	}

	@Override
	public boolean hasExporter() {
		return this.getModelObject().isSetExporter();
	}

	
	
	@Override
	public String getExporterVersion() {
		return this.getModelObject().getExporterVersion();
	}

	@Override
	public void setExporterVersion(String value) {
		this.getModelObject().setExporterVersion(value);
	}

	@Override
	public boolean hasExporterVersion() {
		return this.getModelObject().isSetExporterVersion();
	}

	
	
	@Override
	public Map<QName, String> getOtherAttributes() {
		return this.getModelObject().getOtherAttributes();
	}
	
	@Override
	public void addOtherAttribute(QName arg0, String arg1) {
		this.getModelObject().getOtherAttributes().put(arg0, arg1);
	}

	@Override
	public void clearOtherAttributes() {
		this.getModelObject().getOtherAttributes().clear();
	}

	@Override
	public String getOtherAttribute(QName arg0) {
		return this.getModelObject().getOtherAttributes().get(arg0);
	}

	@Override
	public boolean hasOtherAttribute(QName arg0) {
		return this.getModelObject().getOtherAttributes().containsKey(arg0);
	}

	@Override
	public void removeOtherAttribute(QName arg0) {
		this.getModelObject().getOtherAttributes().remove(arg0);
	}

}
