/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TExtensionElements;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTExtensionElements;

class TExtensionElementsImpl extends AbstractJaxbXmlObjectImpl<EJaxbTExtensionElements>
implements TExtensionElements {

	protected TExtensionElementsImpl(XmlContext xmlContext,
			EJaxbTExtensionElements jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbTExtensionElements> getCompliantModelClass() {
		return EJaxbTExtensionElements.class;
	}

	
    @Override
    public final void addAnyXmlObject(XmlObject anyXmlObject) {
    	addToAny(getModelObject().getAny(), anyXmlObject);
    }

    @Override
    public final void clearAnyXmlObjects() {
        clearChildren(getModelObject().getAny(), Object.class,
                AbstractJaxbXmlObjectImpl.ANY_QNAME);
    }

    @Override
    public final <X extends XmlObject> X getFirstAnyXmlObject(
            Class<X> interfaceClass) {
        X[] children = getAnyXmlObjects(interfaceClass);
        if (children.length == 0)
            return null;
        return children[0];
    }

    @Override
    public final XmlObject[] getAnyXmlObjects() {
        XmlObject[] anyXmlObjects = createChildrenArray(getModelObject()
                .getAny(), Object.class, AbstractJaxbXmlObjectImpl.ANY_QNAME);
        return anyXmlObjects;
    }

    @SuppressWarnings("unchecked")
    @Override
    public final <X extends XmlObject> X[] getAnyXmlObjects(
            Class<X> interfaceClass) {
        XmlObject[] anyXmlObjects = getAnyXmlObjects();
        List<XmlObject> result = new ArrayList<XmlObject>();
        for (XmlObject anyXmlObject : anyXmlObjects) {
            if (!interfaceClass.isInstance(anyXmlObject))
                continue;
            result.add(anyXmlObject);
        }
        return (X[]) result.toArray(new XmlObject[result.size()]);
    }

    @Override
    public final XmlObject[] getAnyXmlObjects(QName qname) {
        XmlObject[] anyXmlObjects = getAnyXmlObjects();
        List<XmlObject> result = new ArrayList<XmlObject>();
        for (XmlObject anyXmlObject : anyXmlObjects) {
            if (!qname.equals(anyXmlObject.getXmlObjectQName()))
                continue;
            result.add(anyXmlObject);
        }
        return (XmlObject[]) result.toArray(new XmlObject[result.size()]);
    }

    @Override
    public final boolean hasAnyXmlObject(QName qname) {
        XmlObject[] anyXmlObjects = getAnyXmlObjects();
        for (XmlObject anyXmlObject : anyXmlObjects) {
            if (qname.equals(anyXmlObject.getXmlObjectQName()))
                return true;
        }
        return false;
    }

    @Override
    public final void removeAnyXmlObject(XmlObject anyXmlObject) {
        removeFromChildren(getModelObject().getAny(), anyXmlObject);
    }
}
