/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TOperation;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTOperation;

public class TOperationImpl extends AbstractTBaseElementImpl<EJaxbTOperation>
		implements TOperation {

	protected TOperationImpl(XmlContext xmlContext, EJaxbTOperation jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public QName getInMessageRef() {
		return this.getModelObject().getInMessageRef();
	}

	@Override
	public void setInMessageRef(QName value) {
		this.getModelObject().setInMessageRef(value);
	}

	@Override
	public boolean hasInMessageRef() {
		return this.getModelObject().isSetInMessageRef();
	}

	@Override
	public QName getOutMessageRef() {
		return this.getModelObject().getOutMessageRef();
	}

	@Override
	public void setOutMessageRef(QName value) {
		this.getModelObject().setOutMessageRef(value);
	}

	@Override
	public boolean hasOutMessageRef() {
		return this.getModelObject().isSetOutMessageRef();
	}

	@Override
	public QName[] getErrorRef() {
		return this.getModelObject().getErrorRef().toArray(new QName[getModelObject().getErrorRef().size()]);
	}
	
	@Override
	public void addErrorRef(QName errorRef) {
		this.getModelObject().getErrorRef().add(errorRef);
	}

	@Override
	public void removeErrorRef(QName errorRef) {
		this.getModelObject().getErrorRef().remove(errorRef);
	}

	@Override
	public boolean hasErrorRef() {
		return this.getModelObject().isSetErrorRef();
	}

	@Override
	public void unsetErrorRef() {
		this.getModelObject().unsetErrorRef();
	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);
	}

	@Override
	public boolean hasName() {
		return this.getModelObject().isSetName();
	}

	@Override
	public QName getImplementationRef() {
		return this.getModelObject().getImplementationRef();
	}

	@Override
	public void setImplementationRef(QName value) {
		this.getModelObject().setImplementationRef(value);

	}

	@Override
	public boolean hasImplementationRef() {
		return this.getModelObject().isSetImplementationRef();
	}

	@Override
	protected Class<? extends EJaxbTOperation> getCompliantModelClass() {
		return EJaxbTOperation.class;
	}

}
