/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Script;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TScriptTask;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTScript;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTScriptTask;

class TScriptTaskImpl extends TTaskImpl
		implements TScriptTask {

	protected TScriptTaskImpl(XmlContext xmlContext, EJaxbTScriptTask jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public EJaxbTScriptTask getModelObject() {
		return (EJaxbTScriptTask) super.getModelObject();
	}
	
	@Override
	protected Class<? extends EJaxbTScriptTask> getCompliantModelClass() {
		return EJaxbTScriptTask.class;
	}

	@Override
	public Script getScript() {
		return this.getXmlContext().getXmlObjectFactory()
				.wrap(this.getModelObject().getScript(), Script.class);
	}

	@Override
	public void setScript(Script value) {
		this.getModelObject().setScript((EJaxbTScript) value);

	}

	@Override
	public boolean isSetScript() {
		return this.getModelObject().isSetScript();
	}

	@Override
	public String getScriptFormat() {
		return this.getModelObject().getScriptFormat();
	}

	@Override
	public void setScriptFormat(String value) {
		this.getModelObject().setScriptFormat(value);

	}

	@Override
	public boolean isSetScriptFormat() {
		return this.getModelObject().isSetScriptFormat();
	}

}
