/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.math.BigInteger;

import javax.xml.bind.JAXBElement;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataInputAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataOutputAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.InputOutputSpecification;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.LoopCharacteristics;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Property;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ResourceRole;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SequenceFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TActivity;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTActivity;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTDataInputAssociation;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTDataOutputAssociation;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTLoopCharacteristics;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTProperty;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTResourceRole;

abstract class AbstractTActivityImpl<Model extends EJaxbTActivity>
extends AbstractTFlowNodeImpl<Model> implements TActivity{

	protected AbstractTActivityImpl(XmlContext xmlContext, Model jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public InputOutputSpecification getIoSpecification() {
	    if(this.getModelObject().getIoSpecification()==null){
	        return null;
	    }
		return this
				.getXmlContext()
				.getXmlObjectFactory()
				.wrap(this.getModelObject().getIoSpecification(),
						InputOutputSpecificationImpl.class);
	}

	@Override
	public void setIoSpecification(InputOutputSpecification value) {
	    if(value!=null) {
	        this.getModelObject().setIoSpecification(((InputOutputSpecificationImpl)value).getModelObject());
	    }
	    else{
	        this.getModelObject().setIoSpecification(null);
	    }
	}

	@Override
	public boolean hasIoSpecification() {
		return this.getModelObject().isSetIoSpecification();
	}

	@Override
	public Property[] getProperty() {
		return createChildrenArray(getModelObject().getProperty(),
				EJaxbTProperty.class, ANY_QNAME, PropertyImpl.class);
	}

	@Override
	public boolean hasProperty() {
		return this.getModelObject().isSetProperty();
	}

	@Override
	public void unsetProperty() {
		this.getModelObject().unsetProperty();
	}
	
	@Override
	public void addProperty(Property p){
		this.getModelObject().getProperty().add(((PropertyImpl)p).getModelObject());
	}
	
	@Override
	public void removeProperty(Property p){
		this.getModelObject().getProperty().remove(((PropertyImpl)p).getModelObject());
	}

	@Override
	public DataInputAssociation[] getDataInputAssociation() {
		return createChildrenArray(getModelObject().getDataInputAssociation(),
				EJaxbTDataInputAssociation.class, ANY_QNAME, DataInputAssociationImpl.class);
	}

	@Override
	public boolean hasDataInputAssociation() {
		return this.getModelObject().isSetDataInputAssociation();
	}

	@Override
	public void unsetDataInputAssociation() {
		this.getModelObject().unsetDataInputAssociation();

	}
	
	@Override
	public void addDataInputAssociation(DataInputAssociation dia){
		this.getModelObject().getDataInputAssociation().add(((DataInputAssociationImpl)dia).getModelObject());
	}
	
	@Override
	public void removeDataInputAssociation(DataInputAssociation dia){
		this.getModelObject().getDataInputAssociation().remove(((DataInputAssociationImpl)dia).getModelObject());
	}

	@Override
	public DataOutputAssociation[] getDataOutputAssociation() {
		return createChildrenArray(getModelObject().getDataOutputAssociation(),
				EJaxbTDataOutputAssociation.class, ANY_QNAME, DataOutputAssociationImpl.class);
	}

	@Override
	public boolean hasDataOutputAssociation() {
		return this.getModelObject().isSetDataOutputAssociation();
	}

	@Override
	public void unsetDataOutputAssociation() {
		this.getModelObject().unsetDataOutputAssociation();
	}
	
	@Override
	public void addDataOutputAssociation(DataOutputAssociation doa){
		this.getModelObject().getDataOutputAssociation().add(((DataOutputAssociationImpl)doa).getModelObject());
	}
	
	@Override
	public void removeDataOutputAssociation(DataOutputAssociation doa){
		this.getModelObject().getDataOutputAssociation().remove(((DataOutputAssociationImpl)doa).getModelObject());
	}

	@Override
	public ResourceRole[] getResourceRole() {
		return createChildrenArray(getModelObject().getResourceRole(),
				EJaxbTResourceRole.class, ANY_QNAME, ResourceRoleImpl.class);
	}

	@Override
	public boolean hasResourceRole() {
		return this.getModelObject().isSetResourceRole();
	}

	@Override
	public void unsetResourceRole() {
		this.getModelObject().unsetResourceRole();
	}
	
	@Override
	public void addResourceRole(ResourceRole r){
		addToChildren(getModelObject().getResourceRole(), r);
	}
	
	@Override
	public void removeResourceRole(ResourceRole r){
		removeFromChildren(getModelObject().getResourceRole(), r);
	}

	@Override
	public LoopCharacteristics getLoopCharacteristics() {
		return (LoopCharacteristics)this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject()
				.getLoopCharacteristics().getValue());
	}

	@SuppressWarnings("unchecked")
	@Override
	public void setLoopCharacteristics(LoopCharacteristics value) {
		if (value != null) {
			JAXBElement<? extends EJaxbTLoopCharacteristics> e 
			= new JAXBElement<EJaxbTLoopCharacteristics>(LoopCharacteristics.QNAME,
					EJaxbTLoopCharacteristics.class,((AbstractTLoopCharacteristicsImpl<EJaxbTLoopCharacteristics>)value).getModelObject());
			this.getModelObject().setLoopCharacteristics(e);
		}
	}

	@Override
	public boolean hasLoopCharacteristics() {
		return this.getModelObject().isSetLoopCharacteristics();
	}

	@Override
	public boolean isIsForCompensation() {
		return this.getModelObject().isIsForCompensation();
	}

	@Override
	public void setIsForCompensation(boolean value) {
		this.getModelObject().setIsForCompensation(value);
	}

	@Override
	public boolean hasIsForCompensation() {
		return this.getModelObject().isSetIsForCompensation();
	}

	@Override
	public void unsetIsForCompensation() {
		this.getModelObject().unsetIsForCompensation();

	}

	@Override
	public int getStartQuantity() {
		return (this.getModelObject().getStartQuantity().intValue());

	}

	@Override
	public void setStartQuantity(int value) {
		this.getModelObject().setStartQuantity(BigInteger.valueOf(value));
	}

	@Override
	public boolean hasStartQuantity() {
		return this.getModelObject().isSetStartQuantity();
	}

	@Override
	public int getCompletionQuantity() {
		return this.getModelObject().getCompletionQuantity().intValue();
	}

	@Override
	public void setCompletionQuantity(int value) {
		this.getModelObject().setCompletionQuantity(BigInteger.valueOf(value));
	}

	@Override
	public boolean hasCompletionQuantity() {
		return this.getModelObject().isSetCompletionQuantity();
	}

	@Override
	public SequenceFlow getDefault() {
		if(this.getModelObject().getDefault()!=null){
			return (SequenceFlow) getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getDefault());
		}
		return null;
	}

	@Override
	public void setDefault(SequenceFlow value) {
		if(value==null){
			this.getModelObject().setDefault(null);
		}
		else{
			this.getModelObject().setDefault(((TSequenceFlowImpl)value).getModelObject());
		}
	}

	@Override
	public boolean hasDefault() {
		return this.getModelObject().isSetDefault();
	}

}
