/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TGatewayDirection;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTGateway;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTGatewayDirection;

abstract class AbstractTGatewayImpl<Model extends EJaxbTGateway>
extends AbstractTFlowNodeImpl<Model> implements TGateway{

	protected AbstractTGatewayImpl(XmlContext xmlContext, Model jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public TGatewayDirection getGatewayDirection() {
		TGatewayDirection result = null;
		switch(getModelObject().getGatewayDirection()){
		case CONVERGING:
			result = TGatewayDirection.Converging;
			break;
		case DIVERGING:
			result = TGatewayDirection.Diverging;
			break;
		case MIXED:
			result = TGatewayDirection.Mixed;
			break;
		case UNSPECIFIED:
			result = TGatewayDirection.Unspecified;
			break;
		}
		return result;
	}

	@Override
	public void setGatewayDirection(TGatewayDirection value) {
		if (value == null) {
			getModelObject().setGatewayDirection(null);
		} else if (value.equals(TGatewayDirection.Converging)) {
			getModelObject().setGatewayDirection(
					EJaxbTGatewayDirection.CONVERGING);
		} else if (value.equals(TGatewayDirection.Diverging)) {
			getModelObject().setGatewayDirection(
					EJaxbTGatewayDirection.DIVERGING);
		} else if (value.equals(TGatewayDirection.Mixed)) {
			getModelObject().setGatewayDirection(EJaxbTGatewayDirection.MIXED);
		} else if (value.equals(TGatewayDirection.Unspecified)) {
			getModelObject().setGatewayDirection(
					EJaxbTGatewayDirection.UNSPECIFIED);
		}
	}

	@Override
	public boolean hasGatewayDirection() {
		return this.getModelObject().isSetGatewayDirection();
	}

}
