/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TLinkEventDefinition;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTLinkEventDefinition;

class TLinkEventDefinitionImpl extends
		AbstractTEventDefinitionImpl<EJaxbTLinkEventDefinition> implements
		TLinkEventDefinition {

	protected TLinkEventDefinitionImpl(XmlContext xmlContext,
			EJaxbTLinkEventDefinition jaxbModel) {
		super(xmlContext, jaxbModel);

	}

	@Override
	protected Class<? extends EJaxbTLinkEventDefinition> getCompliantModelClass() {
		return EJaxbTLinkEventDefinition.class;
	}


	@Override
	public QName[] getSource() {
		List<QName> l = this.getModelObject().getSource();
		return l.toArray(new QName[l.size()]);
	}

	@Override
	public boolean hasSource() {
		return this.getModelObject().isSetSource();
	}

	@Override
	public void unsetSource() {
		this.getModelObject().unsetSource();
	}

	@Override
	public QName getTarget() {
		return this.getModelObject().getTarget();
	}

	@Override
	public void setTarget(QName value) {
		this.getModelObject().setTarget(value);
	}

	@Override
	public boolean hasTarget() {
		return this.getModelObject().isSetTarget();
	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);
	}

	@Override
	public boolean hasName() {
		return this.getModelObject().isSetName();
	}

}
