/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TRelationship;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TRelationshipDirection;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTRelationship;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTRelationshipDirection;

public class TRelationshipImpl extends
		AbstractTBaseElementImpl<EJaxbTRelationship> implements TRelationship {

	protected TRelationshipImpl(XmlContext xmlContext,
			EJaxbTRelationship jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public QName[] getSource() {
		List<QName> l = this.getModelObject().getSource();
		return l.toArray(new QName[l.size()]);
	}

	@Override
	public boolean hasSource() {
		return this.getModelObject().isSetSource();
	}

	@Override
	public void unsetSource() {
		this.getModelObject().unsetSource();
	}

	@Override
	public QName[] getTarget() {
		List<QName> l = this.getModelObject().getTarget();
		return l.toArray(new QName[l.size()]);
	}

	@Override
	public boolean hasTarget() {
		return this.getModelObject().isSetTarget();
	}

	@Override
	public void unsetTarget() {
		this.getModelObject().unsetTarget();
	}

	@Override
	public String getType() {
		return this.getModelObject().getType();
	}

	@Override
	public void setType(String value) {
		this.getModelObject().setType(value);

	}

	@Override
	public boolean hasType() {
		return this.getModelObject().isSetType();
	}

	@Override
	public TRelationshipDirection getDirection() {
		if (getModelObject().getDirection() == null){
			return null;
		}
		TRelationshipDirection result = null;
		switch(this.getModelObject().getDirection()){
		case BACKWARD:
			result = TRelationshipDirection.Backward;
			break;
		case BOTH:
			result = TRelationshipDirection.Both;
			break;
		case FORWARD:
			result = TRelationshipDirection.Forward;
			break;
		case NONE:
			result = TRelationshipDirection.None;
			break;
		}
		return result;
	}

	@Override
	public void setDirection(TRelationshipDirection value) {

		if (value == null) {
			this.getModelObject().setDirection(null);
		} else if (value.equals(TRelationshipDirection.Backward)) {
			getModelObject().setDirection(EJaxbTRelationshipDirection.BACKWARD);
		} else if (value.equals(TRelationshipDirection.Both)) {
			getModelObject().setDirection(EJaxbTRelationshipDirection.BOTH);
		} else if (value.equals(TRelationshipDirection.Forward)) {
			getModelObject().setDirection(EJaxbTRelationshipDirection.FORWARD);
		} else if (value.equals(TRelationshipDirection.None)) {
			getModelObject().setDirection(EJaxbTRelationshipDirection.NONE);
		}
	}

	@Override
	public boolean hasDirection() {
		return this.getModelObject().isSetDirection();
	}

	@Override
	protected Class<? extends EJaxbTRelationship> getCompliantModelClass() {
		return EJaxbTRelationship.class;
	}
}
