/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn20diagram.api;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNEdge;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.Point;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.type.TMessageVisibleKind;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class BPMNEdgeChildrenTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_NUMBER_POINT = "numberOfPoint";
    public static final String EXPECTED_MESSAGEVISIBLEKIND = "expectedMessageVicsbleKind";
    private static final int MINIMAL_NUMBER_POINT = 2;

    public BPMNEdgeChildrenTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetAllChildren() {
        BPMNEdge identifiedObject = (BPMNEdge)this.newXmlObjectUnderTest();
        Point[] points = identifiedObject.getWaypoint();
        Assert.assertNotNull((Object)points);
        Assert.assertTrue((2 <= points.length ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.getTestData(EXPECTED_NUMBER_POINT), (Object)points.length);
        if (this.getTestData(EXPECTED_MESSAGEVISIBLEKIND) != null) {
            TMessageVisibleKind mvk = identifiedObject.getMessageVisibleKind();
            Assert.assertNotNull((Object)mvk);
            Assert.assertEquals((Object)this.getTestData(EXPECTED_MESSAGEVISIBLEKIND), (Object)mvk);
        }
    }

    @Test
    public void setMessageVisibleKindTest() {
        BPMNEdge identifiedObject = (BPMNEdge)this.newXmlObjectUnderTest();
        for (TMessageVisibleKind newMVK : TMessageVisibleKind.values()) {
            identifiedObject.setMessageVisibleKind(newMVK);
            Assert.assertTrue((boolean)identifiedObject.hasMessageVisibleKind());
            TMessageVisibleKind mvk = identifiedObject.getMessageVisibleKind();
            Assert.assertNotNull((Object)mvk);
            Assert.assertEquals((Object)newMVK, (Object)mvk);
        }
        TMessageVisibleKind newMVK = null;
        identifiedObject.setMessageVisibleKind(newMVK);
        TMessageVisibleKind mvk = identifiedObject.getMessageVisibleKind();
        Assert.assertEquals(newMVK, (Object)mvk);
    }

    @Test
    public void testRemoveChildPoint() {
        BPMNEdge identifiedObject = (BPMNEdge)this.newXmlObjectUnderTest();
        Point[] points = identifiedObject.getWaypoint();
        Assert.assertNotNull((Object)points);
        Assert.assertTrue((2 <= points.length ? 1 : 0) != 0);
        identifiedObject.removeWayPoint(points[0]);
        points = identifiedObject.getWaypoint();
        Assert.assertEquals((int)((Integer)this.getTestData(EXPECTED_NUMBER_POINT) - 1), (int)points.length);
    }

    @Test
    public void testAddChildPoint() {
        BPMNEdge identifiedObject = (BPMNEdge)this.newXmlObjectUnderTest();
        Point[] points = identifiedObject.getWaypoint();
        Assert.assertNotNull((Object)points);
        Assert.assertTrue((2 <= points.length ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.getTestData(EXPECTED_NUMBER_POINT), (Object)points.length);
        Point point = (Point)this.getXmlContext().getXmlObjectFactory().create(Point.class);
        point.setX(222.0);
        point.setY(333.0);
        identifiedObject.addWayPoint(point);
        Assert.assertTrue((boolean)identifiedObject.hasWaypoint());
        points = identifiedObject.getWaypoint();
        Assert.assertNotNull((Object)points);
        Assert.assertTrue((3 <= points.length ? 1 : 0) != 0);
        Assert.assertEquals((int)((Integer)this.getTestData(EXPECTED_NUMBER_POINT) + 1), (int)points.length);
        boolean found = false;
        for (Point p : points) {
            if (p.getX() != 222.0 || p.getY() != 333.0) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testUnsetAllChildren() {
        BPMNEdge identifiedObject = (BPMNEdge)this.newXmlObjectUnderTest();
        identifiedObject.unsetWaypoint();
        Assert.assertFalse((boolean)identifiedObject.hasWaypoint());
    }
}

