/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.io;

import com.ebmwebsourcing.easycommons.io.FileSystemHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.SystemUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileSystemHelperLinuxOnlyTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Before
    public void linuxOnly() {
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_LINUX);
    }

    @Test(expected=IOException.class)
    public void testCleanRestrictedDirectory() throws IOException {
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_LINUX);
        File restrictedDirectory = this.tempFolder.newFolder("restricted-folder");
        Assert.assertTrue((boolean)restrictedDirectory.setReadable(false));
        Assert.assertTrue((boolean)restrictedDirectory.setWritable(false));
        try {
            FileSystemHelper.cleanDirectory((File)restrictedDirectory);
        }
        catch (IOException e) {
            restrictedDirectory.setReadable(true);
            restrictedDirectory.setWritable(true);
            throw e;
        }
        Assert.fail((String)"Cleaning a restricted directory isn't allowed");
    }

    @Test(expected=IOException.class)
    public void testForceDeleteRestrictedDirectory() throws IOException {
        File restrictedDirectory = this.tempFolder.newFolder("restricted-folder");
        Assert.assertTrue((boolean)restrictedDirectory.setReadable(false));
        Assert.assertTrue((boolean)restrictedDirectory.setWritable(false));
        try {
            FileSystemHelper.forceDelete((File)restrictedDirectory);
        }
        catch (IOException e) {
            restrictedDirectory.setReadable(true);
            restrictedDirectory.setWritable(true);
            throw e;
        }
        Assert.fail((String)"Deleting a restricted directory isn't allowed");
    }
}

