/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.io;

import com.ebmwebsourcing.easycommons.io.ZipHelper;
import java.io.File;
import java.net.URL;
import java.util.zip.ZipFile;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ZipHelperTest {
    private static ZipFile testArchive;
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @BeforeClass
    public static void beforeClass() throws Exception {
        URL testArchiveUrl = ZipHelperTest.class.getClassLoader().getResource("test.zip");
        testArchive = new ZipFile(new File(testArchiveUrl.toURI()));
    }

    @Test
    public void testExtractAllEntriesFromArchive() throws Exception {
        File tempDir = this.temporaryFolder.newFolder("extract-archive-all-entries");
        ZipHelper.extractEntriesFromArchive((ZipFile)testArchive, (String)"", (File)tempDir);
        Assert.assertTrue((boolean)new File(tempDir, "test/file1.txt").exists());
        Assert.assertTrue((boolean)new File(tempDir, "test/file2.txt").exists());
        Assert.assertTrue((boolean)new File(tempDir, "test/3file.txt").exists());
        Assert.assertTrue((boolean)new File(tempDir, "test/emptyDir/anotherEmptyDir1").exists());
        Assert.assertTrue((boolean)new File(tempDir, "test/emptyDir/anotherEmptyDir2").exists());
    }

    @Test
    public void testExtractOnlyAnEntryFromArchive() throws Exception {
        File tempDir = this.temporaryFolder.newFolder("extract-archive-one-entry");
        ZipHelper.extractEntriesFromArchive((ZipFile)testArchive, (String)"test/3file.txt", (File)tempDir);
        Assert.assertTrue((!new File(tempDir, "test/file1.txt").exists() ? 1 : 0) != 0);
        Assert.assertTrue((!new File(tempDir, "test/file2.txt").exists() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)new File(tempDir, "test/3file.txt").exists());
        Assert.assertTrue((!new File(tempDir, "test/emptyDir/anotherEmptyDir1").exists() ? 1 : 0) != 0);
        Assert.assertTrue((!new File(tempDir, "test/emptyDir/anotherEmptyDir2").exists() ? 1 : 0) != 0);
    }

    @Test
    public void testExtractEntriesStartingWithEntryNamePrefixFromArchive() throws Exception {
        File tempDir = this.temporaryFolder.newFolder("extract-archive-all-entries-entries-from-prefix");
        ZipHelper.extractEntriesFromArchive((ZipFile)testArchive, (String)"test/fi", (File)tempDir);
        Assert.assertTrue((boolean)new File(tempDir, "test/file1.txt").exists());
        Assert.assertTrue((boolean)new File(tempDir, "test/file2.txt").exists());
        Assert.assertTrue((!new File(tempDir, "test/3file.txt").exists() ? 1 : 0) != 0);
        Assert.assertTrue((!new File(tempDir, "test/emptyDir/anotherEmptyDir1").exists() ? 1 : 0) != 0);
        Assert.assertTrue((!new File(tempDir, "test/emptyDir/anotherEmptyDir2").exists() ? 1 : 0) != 0);
    }

    @Test
    public void testExtractEntriesFromArchiveContainingEmptyDir() throws Exception {
        File tempDir = this.temporaryFolder.newFolder("extract-archive-with-empty-dir");
        ZipHelper.extractEntriesFromArchive((ZipFile)testArchive, (String)"test/emptyDir", (File)tempDir);
        Assert.assertTrue((!new File(tempDir, "test/file1.txt").exists() ? 1 : 0) != 0);
        Assert.assertTrue((!new File(tempDir, "test/file2.txt").exists() ? 1 : 0) != 0);
        Assert.assertTrue((!new File(tempDir, "test/3file.txt").exists() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)new File(tempDir, "test/emptyDir/anotherEmptyDir1").exists());
        Assert.assertTrue((boolean)new File(tempDir, "test/emptyDir/anotherEmptyDir2").exists());
    }
}

