/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.lang;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import org.junit.Assert;
import org.junit.Test;

public class StringHelperTest {
    @Test
    public void testIsNullOrEmptyWithNullObject() {
        Assert.assertTrue((boolean)StringHelper.isNullOrEmpty(null));
    }

    @Test
    public void testIsNullOrEmptyWithEmptyString() {
        Assert.assertTrue((boolean)StringHelper.isNullOrEmpty((String)new String("")));
    }

    @Test
    public void testIsNullOrEmptyWithNonEmptyString() {
        Assert.assertFalse((boolean)StringHelper.isNullOrEmpty((String)new String("John doe")));
    }

    @Test
    public void testNonNullValueWithNullObject() {
        Object obj = null;
        String result = StringHelper.nonNullValue(obj);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.length() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNonNullValueWithNonNullObject() {
        Integer integer = new Integer(4);
        String result = StringHelper.nonNullValue((Object)integer);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.equals("4"));
    }

    @Test
    public void testEqualsWithNullInstance() {
        String s1 = null;
        String s2 = null;
        Assert.assertTrue((boolean)StringHelper.equal(s1, s2));
    }

    @Test
    public void testEqualsWithOneNullInstance() {
        String s1 = null;
        String s2 = "test";
        Assert.assertFalse((boolean)StringHelper.equal(s1, (String)s2));
        Assert.assertFalse((boolean)StringHelper.equal((String)s2, s1));
    }

    @Test
    public void testEqualsWithNonNullInstance() {
        String s1 = "petals";
        String s2 = "petals";
        Assert.assertTrue((boolean)StringHelper.equal((String)s1, (String)s2));
    }
}

