/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.lang;

import com.ebmwebsourcing.easycommons.lang.CollectionHelper;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class CollectionHelperTest {
    @Test
    public void filterListWithOneFilter() {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        for (int i = 1; i <= 10; ++i) {
            lst.add(i);
        }
        Assert.assertEquals((long)10L, (long)lst.size());
        ArrayList<PairNumberFilter> filters = new ArrayList<PairNumberFilter>();
        filters.add(new PairNumberFilter());
        CollectionHelper.filter(lst, filters);
        Assert.assertEquals((long)5L, (long)lst.size());
        int i = 2;
        for (Integer integer : lst) {
            Assert.assertEquals((long)i, (long)integer.intValue());
            i += 2;
        }
    }

    @Test
    public void filterListWithTwoFilter() {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        for (int i = 1; i <= 10; ++i) {
            lst.add(i);
        }
        Assert.assertEquals((long)10L, (long)lst.size());
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new PairNumberFilter());
        filters.add(new NumberFourFilter());
        CollectionHelper.filter(lst, filters);
        Assert.assertEquals((long)1L, (long)lst.size());
        Assert.assertEquals((long)4L, (long)((Integer)lst.get(0)).intValue());
    }

    class NumberFourFilter
    implements CollectionHelper.Filter<Integer> {
        NumberFourFilter() {
        }

        public boolean accept(Integer item) {
            return item == 4;
        }
    }

    class PairNumberFilter
    implements CollectionHelper.Filter<Integer> {
        PairNumberFilter() {
        }

        public boolean accept(Integer item) {
            return item % 2 == 0;
        }
    }
}

