package com.ebmwebsourcing.easycommons.lang;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public final class ArrayHelper {

    private ArrayHelper() {
    }

    
    @SuppressWarnings("unchecked")
    public static <T> T[] mergeArrays(T[]... arrays) {
        assert arrays != null;
        assert arrays.length > 0;
        int totalLength = 0;
        for (T[] array : arrays) {
            totalLength += array.length;
        }
        T[] merged = (T[]) Array.newInstance(arrays[0].getClass().getComponentType(), 
                totalLength);
        int destPos = 0;
        for (T[] array : arrays) {
            System.arraycopy(array, 0, merged, destPos, array.length);
            destPos += array.length;
        }
        return merged;
    }


    @SuppressWarnings("unchecked")
    public static <T> T[] arrayRemove(T[] array, T... toRemoveObjects) {
        List<T> result = new ArrayList<T>();
        for (T object : array) {
            if (arrayContainsSameObject(toRemoveObjects, object)) continue;
            result.add(object);
        }
        return result.toArray((T[]) Array.newInstance(array.getClass().getComponentType(), result.size()));        
    }
    
    
    public static <T> boolean arrayContainsSameObject(T[] array, T sameObject) {
        for (T object : array) {
            if (object == sameObject) return true;
        }
        return false;
    }
      
    
    
}
