/****************************************************************************
 * Copyright (c) 2010-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easycommons.lang;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Adrien Ruffie - EBM WebSourcing
 */
public final class ArrayHelper {

    private ArrayHelper() {
    }

    
    @SuppressWarnings("unchecked")
    public static <T> T[] mergeArrays(T[]... arrays) {
        assert arrays != null;
        assert arrays.length > 0;
        int totalLength = 0;
        for (T[] array : arrays) {
            totalLength += array.length;
        }
        T[] merged = (T[]) Array.newInstance(arrays[0].getClass().getComponentType(), 
                totalLength);
        int destPos = 0;
        for (T[] array : arrays) {
            System.arraycopy(array, 0, merged, destPos, array.length);
            destPos += array.length;
        }
        return merged;
    }


    @SuppressWarnings("unchecked")
    public static <T> T[] arrayRemove(T[] array, T... toRemoveObjects) {
        List<T> result = new ArrayList<T>();
        for (T object : array) {
            if (arrayContainsSameObject(toRemoveObjects, object)) continue;
            result.add(object);
        }
        return result.toArray((T[]) Array.newInstance(array.getClass().getComponentType(), result.size()));        
    }
    
    
    public static <T> boolean arrayContainsSameObject(T[] array, T sameObject) {
        for (T object : array) {
            if (object == sameObject) return true;
        }
        return false;
    }
      
    
    
}
