/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger;

import com.ebmwebsourcing.easycommons.logger.TestLogData;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class LogDataTest {
    @Test
    public void testPutData() {
        TestLogData logData = new TestLogData();
        logData.putData("testKey", "testValue");
        Assert.assertEquals((Object)"testValue", (Object)logData.get("testKey"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testKeySetUnmodifiable() {
        TestLogData logData = new TestLogData();
        Set keySet = logData.keySet();
        keySet.remove("test");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testEntrySetUnmodifiable() {
        TestLogData logData = new TestLogData();
        logData.putData("test", "testKey");
        Set entrySet = logData.entrySet();
        entrySet.remove(new AbstractMap.SimpleEntry<String, String>("testKey", "testValue"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testValuesUnmodifiable() {
        TestLogData logData = new TestLogData();
        Collection values = logData.values();
        values.remove(new Object());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPutUnsupported() {
        TestLogData logData = new TestLogData();
        logData.put("test", "testKey");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPutAllUnsupported() {
        TestLogData logData = new TestLogData();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("test", "testKey");
        logData.putAll(map);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCloneUnsupported() {
        TestLogData logData = new TestLogData();
        logData.putData("test", "testKey");
        logData.clone();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testClearUnsupported() {
        TestLogData logData = new TestLogData();
        logData.putData("test", "testKey");
        logData.clear();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveUnsupported() {
        TestLogData logData = new TestLogData();
        logData.putData("test", "testKey");
        logData.remove("test");
    }
}

