/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger;

import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.logger.LogDataFormatter;
import com.ebmwebsourcing.easycommons.logger.TestHandler;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoggerTest {
    private Logger logger = null;

    @Before
    public final void setUpLogger() {
        System.getProperties().remove("java.util.logging.manager");
        this.logger = new TestLogger("TESTLOGGER");
        this.logger.setLevel(Level.ALL);
        TestHandler handler = new TestHandler();
        handler.setFormatter((Formatter)new LogDataFormatter());
        handler.setLevel(Level.ALL);
        this.logger.setUseParentHandlers(false);
        this.logger.addHandler(handler);
    }

    @After
    public final void tearDownLogger() {
        for (Handler handler : this.logger.getHandlers()) {
            this.logger.removeHandler(handler);
        }
    }

    @Test
    public final void testLoggingAtOFFLevel() throws Exception {
        this.logger.setLevel(java.util.logging.Level.OFF);
        for (java.util.logging.Level level : Level.getLevels()) {
            this.logger.log(level, "MY Message");
        }
        TestHandler testHandler = TestHandler.extractTestHandler(this.logger);
        Assert.assertEquals((long)0L, (long)testHandler.getAllRecords().size());
    }

    @Test
    public final void testLoggingAtDefaultLevel() throws Exception {
        this.logger.setLevel(null);
        for (java.util.logging.Level level : Level.getLevels()) {
            this.logger.log(level, "MY Message");
        }
        TestHandler testHandler = TestHandler.extractTestHandler(this.logger);
        Assert.assertEquals((long)4L, (long)testHandler.getAllRecords().size());
    }

    @Test
    public final void testLoggingAtALLLevel() throws Exception {
        this.logger.setLevel(java.util.logging.Level.ALL);
        for (java.util.logging.Level level : Level.getLevels()) {
            this.logger.log(level, "MY Message");
        }
        TestHandler testHandler = TestHandler.extractTestHandler(this.logger);
        Assert.assertEquals((long)Level.getLevels().length, (long)testHandler.getAllRecords().size());
    }

    @Test
    public final void testLoggingAtMONITLevel() throws Exception {
        this.logger.setLevel(Level.MONIT);
        for (java.util.logging.Level level : Level.getLevels()) {
            this.logger.log(level, "MY Message");
        }
        TestHandler testHandler = TestHandler.extractTestHandler(this.logger);
        Assert.assertEquals((long)(Arrays.asList(Level.getLevels()).indexOf(Level.MONIT) + 1), (long)testHandler.getAllRecords().size());
    }

    @Test
    public final void testLoggingLotsOfMessages() throws Exception {
        int nbMessages = 1000;
        int maxMessageSize = 128;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(128000);
        StreamHandler streamHandler = new StreamHandler(baos, (Formatter)new LogDataFormatter());
        streamHandler.setLevel(Level.ALL);
        this.logger.addHandler(streamHandler);
        for (int i = 0; i < 1000; ++i) {
            String s = Thread.currentThread().getName();
            this.logger.log(Level.SEVERE, String.valueOf(i) + " " + s);
        }
        streamHandler.flush();
        String s = new String(baos.toByteArray());
        int occurencesOfNewLines = this.countOccurences(s, '\n');
        Assert.assertEquals((long)1000L, (long)occurencesOfNewLines);
    }

    private final int countOccurences(CharSequence s, char c) {
        int result = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++result;
        }
        return result;
    }

    @Test
    public final void testLogsFromSeveralThreadsAreNotInterleaved() throws Exception {
        int i;
        int nbMessages = 100;
        int maxMessageSize = 128;
        int nbThreads = 10;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(128000);
        StreamHandler streamHandler = new StreamHandler(baos, (Formatter)new LogDataFormatter());
        streamHandler.setLevel(Level.ALL);
        this.logger.addHandler(streamHandler);
        String message = "This is the constant message.";
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 100; ++i) {
                    LoggerTest.this.logger.log(Level.INFO, "This is the constant message.");
                }
            }
        };
        Thread[] threads = new Thread[10];
        for (i = 0; i < 10; ++i) {
            threads[i] = new Thread(r, "thread" + i);
        }
        for (i = 0; i < 10; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            threads[i].join();
        }
        streamHandler.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bais));
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            line = line.substring(line.indexOf(": ") + 2);
            Assert.assertEquals((Object)"This is the constant message.", (Object)line);
        }
    }

    private static class TestLogger
    extends Logger {
        public TestLogger(String name) {
            super(name, null);
        }
    }
}

