/**
 * 
 */
package com.ebmwebsourcing.easycommons.logger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * @author aruffie
 * Class util which provide several helping methods
 */
public final class LoggerHelper {

    private LoggerHelper() {
    }
    
    /**
     * Get the level of a logger or the level owned by its parent.
     * @param logger a logger
     * @return the level of the logger or the level owned by its parent.
     */
    public static final Level getLevelOrParentLevel (final Logger logger) {
        assert logger != null;
        Level level = logger.getLevel();
        if(level == null) {
            assert logger.getParent() != null;
            level = getLevelOrParentLevel(logger.getParent());
        }
        return level;
    }
    
    /**
     * Get the handlers of a logger and the handlers owned by its parent if
     * it sends its output to its parent
     * @param logger a logger
     * @return the list of handlers of a logger and the handlers owned by its parent if
     * it sends its output to its parent
     */
    public static final List<Handler> getHandlersOrParentHanders(final Logger logger) {
        List<Handler> handlers = new ArrayList<Handler>(Arrays.asList(logger.getHandlers()));
        if(logger.getUseParentHandlers() && logger.getParent() != null) {
            handlers.addAll(getHandlersOrParentHanders(logger.getParent()));
        }
        return handlers;
    }
}
