/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger.handler;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.properties.PropertiesException;
import com.ebmwebsourcing.easycommons.properties.PropertiesHelper;
import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class ContextualFileHandler
extends StreamHandler {
    private static final String PROPERTY_NAME_PREFIX = ContextualFileHandler.class.getName();
    private static final String BASEDIR_PROPERTY_NAME = PROPERTY_NAME_PREFIX + ".basedir";
    private static final String SUBDIR_PROPERTY_NAME = PROPERTY_NAME_PREFIX + ".subdir";
    private static final String LOGFILENAME_PROPERTY_NAME = PROPERTY_NAME_PREFIX + ".logFilename";
    static final String DEFAULT_LOG_FILE_NAME = "default.log";
    private final String basedir;
    private final String subdir;
    private final String logFilename;

    protected ContextualFileHandler(String basedir, String subdir, String logFilename, Properties systemProperties) {
        assert (basedir != null);
        assert (subdir != null);
        assert (logFilename != null);
        assert (systemProperties != null);
        if (logFilename.isEmpty()) {
            throw new UncheckedException("The log filename cannot be empty.");
        }
        if (logFilename.contains(File.separator)) {
            throw new UncheckedException("The log filename cannot contain a file separator.");
        }
        try {
            this.basedir = PropertiesHelper.resolveString((String)basedir, (Properties)systemProperties);
        }
        catch (PropertiesException pe) {
            throw new UncheckedException((Throwable)pe);
        }
        this.subdir = subdir;
        this.logFilename = logFilename;
    }

    public ContextualFileHandler() throws IOException, PropertiesException {
        this(ContextualFileHandler.getStringProperty(BASEDIR_PROPERTY_NAME, System.getProperty("user.dir")), ContextualFileHandler.getStringProperty(SUBDIR_PROPERTY_NAME, ""), ContextualFileHandler.getStringProperty(LOGFILENAME_PROPERTY_NAME, DEFAULT_LOG_FILE_NAME), System.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void publish(LogRecord record) {
        File logFile = null;
        try {
            logFile = this.getLogFile();
        }
        catch (PropertiesException pe) {
            this.reportError(pe.getMessage(), (Exception)((Object)pe), 0);
        }
        if (logFile != null) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(logFile, true);
                super.setOutputStream(fos);
                super.publish(record);
                super.close();
            }
            catch (FileNotFoundException e) {
                this.reportError(null, e, 4);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        this.reportError(null, e, 3);
                    }
                }
            }
        }
    }

    private File getLogFile() throws PropertiesException {
        Properties contextualProperties = PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties());
        String resolvedSubdir = null;
        String resolvedLogFilename = null;
        resolvedSubdir = PropertiesHelper.resolveString((String)this.subdir, (Properties)contextualProperties);
        resolvedLogFilename = PropertiesHelper.resolveString((String)this.logFilename, (Properties)contextualProperties);
        assert (resolvedSubdir != null);
        assert (resolvedLogFilename != null);
        File logFileDir = new File(this.basedir, resolvedSubdir);
        logFileDir.mkdirs();
        File logFile = new File(logFileDir, resolvedLogFilename);
        return logFile;
    }

    protected static final String getStringProperty(String name, String defaultValue) {
        String val = LogManager.getLogManager().getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    final String getBasedir() {
        return this.basedir;
    }

    final String getSubdir() {
        return this.subdir;
    }

    final String getLogFilename() {
        return this.logFilename;
    }
}

