/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.sca.helper.impl;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.Binding;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAIntentHelper;
import com.ebmwebsourcing.easycommons.sca.helper.util.Console;
import com.ebmwebsourcing.easycommons.sca.helper.util.CreateHelloWorld;
import com.ebmwebsourcing.easycommons.sca.helper.util.DebugConsoleHandlerImpl;
import com.ebmwebsourcing.easycommons.sca.helper.util.HelloWorldClient;
import com.ebmwebsourcing.easycommons.sca.helper.util.HelloWorldServiceImpl;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.IntentHandler;
import org.ow2.frascati.tinfi.api.control.SCAIntentController;

public class SCAIntentHelperTest {
    private void addBindingToClient(Component composite) throws SCAException, NoSuchInterfaceException {
        List<Component> children = SCAHelper.getSCAHelper().getComponents(composite);
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        Binding binding = new Binding("helloService", (Interface)children.get(0).getFcInterface("service"));
        bindings.add(binding);
        Assert.assertNull((Object)SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent(children.get(1)).get("helloService"));
        SCAHelper.getSCAHelper().addBindings(children.get(1), bindings);
        Assert.assertNotNull((Object)SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent(children.get(1)).get("helloService"));
    }

    @Test
    public void launchHelloWorldTestWithIntent() {
        try {
            String[] expected = new String[]{"<DEBUG_BEFORE>", HelloWorldServiceImpl.class.getCanonicalName(), "</DEBUG_BEFORE>", "<DEBUG_PROCEED>", "Hello World !!!", "</DEBUG_PROCEED>", "<DEBUG_AFTER/>"};
            Console.init(System.out, expected);
            Component composite = CreateHelloWorld.createHelloWorld();
            this.addBindingToClient(composite);
            List<Component> children = SCAHelper.getSCAHelper().getComponents(composite);
            SCAHelper.getSCAHelper().startComponent(composite);
            SCAHelper.getSCAHelper().startComponent(children.get(0));
            SCAHelper.getSCAHelper().startComponent(children.get(1));
            SCAIntentHelper.getSCAIntentHelper().injectIntentIntoComponent(DebugConsoleHandlerImpl.class.getCanonicalName(), children.get(0));
            SCAIntentController ic = (SCAIntentController)children.get(0).getFcInterface("sca-intent-controller");
            Assert.assertEquals((int)10, (int)ic.listFcIntentHandler("service").size());
            HelloWorldClient s = (HelloWorldClient)children.get(1).getFcInterface("service");
            s.setMessage("Hello World !!!");
            s.run();
            System.out.println();
            SCAIntentHelper.getSCAIntentHelper().releaseIntentInComponent((IntentHandler)ic.listFcIntentHandler("service").get(0), children.get(0));
            Console.init(System.out, new String[]{"Hello World !!!"});
            s.run();
        }
        catch (SCAException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

