/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.registry;

import com.ebmwebsourcing.easycommons.registry.KeyAlreadyBoundException;
import com.ebmwebsourcing.easycommons.registry.KeyNotFoundException;
import com.ebmwebsourcing.easycommons.registry.ResourceRegistry;
import com.ebmwebsourcing.easycommons.registry.concurrency.ConcurrentRegisterTestTask;
import com.ebmwebsourcing.easycommons.registry.concurrency.ConcurrentUnregisterTestTask;
import com.ebmwebsourcing.easycommons.thread.SimultaneousTaskExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class ResourceRegistryTest {
    private static final String KEY_TO_BIND = "KEY_TO_BIND";
    private static final int loopCount = 100;
    private static final int simultaneousThreads = 100;

    @Test
    public void testRegisterAndLookup() {
        ResourceRegistry resourceRegistry = new ResourceRegistry();
        Object objectToBind = new Object();
        resourceRegistry.register(KEY_TO_BIND, objectToBind);
        Assert.assertEquals((Object)objectToBind, (Object)resourceRegistry.lookup(KEY_TO_BIND));
    }

    @Test
    public void testRegisterAndUnregister() {
        ResourceRegistry resourceRegistry = new ResourceRegistry();
        Object objectToBind = new Object();
        resourceRegistry.register(KEY_TO_BIND, objectToBind);
        Assert.assertEquals((Object)objectToBind, (Object)resourceRegistry.lookup(KEY_TO_BIND));
        resourceRegistry.unregister(KEY_TO_BIND);
        Assert.assertNull((Object)resourceRegistry.lookup(KEY_TO_BIND));
    }

    @Test
    public void testRegisterTwiceWithTheSameKey() {
        ResourceRegistry resourceRegistry = new ResourceRegistry();
        Object objectToBind = new Object();
        resourceRegistry.register(KEY_TO_BIND, objectToBind);
        try {
            resourceRegistry.register(KEY_TO_BIND, objectToBind);
            Assert.fail((String)"Must throw a KeyAlreadyBoundException if the register method is called twice on the same registry instance with the same key as parameter");
        }
        catch (KeyAlreadyBoundException keyAlreadyBoundException) {
            // empty catch block
        }
    }

    @Test
    public void testUnregisterWithNotRegisteredKey() {
        ResourceRegistry resourceRegistry = new ResourceRegistry();
        try {
            resourceRegistry.unregister(KEY_TO_BIND);
            Assert.fail((String)"Must throw a KeyNotFoundException if the unregister method is called with a non previously registered key");
        }
        catch (KeyNotFoundException keyNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentRegisteredWithSameKey() throws InterruptedException {
        for (int i = 0; i < 100; ++i) {
            ResourceRegistry resourceRegistry = new ResourceRegistry();
            SimultaneousTaskExecutor simultaneousTaskExecutor = new SimultaneousTaskExecutor();
            AtomicInteger counter = new AtomicInteger(0);
            for (int j = 0; j < 100; ++j) {
                simultaneousTaskExecutor.registerTask((Runnable)new ConcurrentRegisterTestTask(counter, (ResourceRegistry<Object>)resourceRegistry, KEY_TO_BIND));
            }
            simultaneousTaskExecutor.executeAllRegisteredTasks();
            Assert.assertEquals((String)("Failed during loop: " + i), (long)98L, (long)counter.longValue());
        }
    }

    @Test
    public void testConcurrentUnregisteredWithSameKey() throws InterruptedException {
        for (int i = 0; i < 100; ++i) {
            ResourceRegistry resourceRegistry = new ResourceRegistry();
            resourceRegistry.register(KEY_TO_BIND, new Object());
            SimultaneousTaskExecutor simultaneousTaskExecutor = new SimultaneousTaskExecutor();
            AtomicInteger counter = new AtomicInteger(0);
            for (int j = 0; j < 100; ++j) {
                simultaneousTaskExecutor.registerTask((Runnable)new ConcurrentUnregisterTestTask(counter, (ResourceRegistry<Object>)resourceRegistry, KEY_TO_BIND));
            }
            simultaneousTaskExecutor.executeAllRegisteredTasks();
            Assert.assertEquals((String)("Failed during loop: " + i), (long)98L, (long)counter.longValue());
        }
    }
}

