/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2008 OW2 Consortium, http://www.ow2.org/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.easycommons.pooling;

/**
 * A resource handler to manage the resource life cycle. 
 * It enables to control the creation of the resource and to make specific 
 * actions on the getting a resource from the pool and on the putting of
 * a resource to the pool
 * 
 * @author aruffie
 * @author noddoux
 */
public interface ResourceHandler<T> {

    /**
     * Create a resource.
     * 
     * @return a new resource instance.
     */
    T create();

    /**
     * Call when getting a resource from the pool (taking)
     * 
     * @param resource
     *            the resource got from the pool
     */
    void onTake(final T resource);

    /**
     * Call when putting a resource back in the pool (releasing)
     * 
     * @param resource
     *            The resource put back in the pool
     */
    void onRelease(final T resource);
}
