/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easycommons.explorer;

import com.petalslink.easycommons.explorer.ComponentG;
import com.petalslink.easycommons.explorer.ControllerG;
import com.petalslink.easycommons.explorer.ReferenceG;
import com.petalslink.easycommons.explorer.ServiceG;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeComponentModel
implements TreeModel {
    private ComponentG component = null;
    private final List<TreeModelListener> treeModelListeners = new ArrayList<TreeModelListener>();

    public TreeComponentModel(ComponentG component) {
        this.component = component;
    }

    @Override
    public Object getRoot() {
        return this.component;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object res = null;
        if (parent == this.getRoot()) {
            if (index == 0) {
                res = new Components(((ComponentG)parent).getUnderComponents());
            } else if (index == 1) {
                res = new Services(((ComponentG)parent).getServices());
            } else if (index == 2) {
                res = new References(((ComponentG)parent).getReferences());
            } else if (index == 3) {
                res = new Controllers(((ComponentG)parent).getControllers());
            }
        } else if (parent instanceof ComponentG) {
            if (index == 0) {
                res = new Components(((ComponentG)parent).getUnderComponents());
            } else if (index == 1) {
                res = new Services(((ComponentG)parent).getServices());
            } else if (index == 2) {
                res = new References(((ComponentG)parent).getReferences());
            } else if (index == 3) {
                res = new Controllers(((ComponentG)parent).getControllers());
            }
        } else if (parent instanceof Components) {
            res = ((Components)parent).getChilds().get(index);
        } else if (parent instanceof Services) {
            res = ((Services)parent).getChilds().get(index);
        } else if (parent instanceof References) {
            res = ((References)parent).getChilds().get(index);
        } else if (parent instanceof Controllers) {
            res = ((Controllers)parent).getChilds().get(index);
        }
        return res;
    }

    @Override
    public int getChildCount(Object parent) {
        int res = 0;
        if (parent == this.getRoot()) {
            res = 4;
        } else if (parent instanceof ComponentG) {
            res = 4;
        } else if (parent instanceof Components) {
            res = ((Components)parent).getChilds().size();
        } else if (parent instanceof Services) {
            res = ((Services)parent).getChilds().size();
        } else if (parent instanceof References) {
            res = ((References)parent).getChilds().size();
        } else if (parent instanceof Controllers) {
            res = ((Controllers)parent).getChilds().size();
        }
        return res;
    }

    @Override
    public boolean isLeaf(Object node) {
        boolean res = true;
        if (node == this.getRoot()) {
            res = false;
        } else if (node instanceof ComponentG) {
            res = false;
        } else if (node instanceof Components && ((Components)node).getChilds().size() > 0) {
            res = false;
        } else if (node instanceof Services && ((Services)node).getChilds().size() > 0) {
            res = false;
        } else if (node instanceof References && ((References)node).getChilds().size() > 0) {
            res = false;
        } else if (node instanceof Controllers && ((Controllers)node).getChilds().size() > 0) {
            res = false;
        }
        return res;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int res = 0;
        if (parent == this.getRoot()) {
            if (child instanceof Components) {
                res = 0;
            } else if (child instanceof Services) {
                res = 1;
            } else if (child instanceof References) {
                res = 2;
            } else if (child instanceof Controllers) {
                res = 3;
            }
        } else if (parent instanceof ComponentG) {
            if (child instanceof Components) {
                res = 0;
            } else if (child instanceof Services) {
                res = 1;
            } else if (child instanceof References) {
                res = 2;
            } else if (child instanceof Controllers) {
                res = 3;
            }
        } else if (parent instanceof Components) {
            res = ((Components)parent).getChilds().indexOf(child);
        } else if (parent instanceof Services) {
            res = ((Services)parent).getChilds().indexOf(child);
        } else if (parent instanceof References) {
            res = ((References)parent).getChilds().indexOf(child);
        } else if (parent instanceof Controllers) {
            res = ((Controllers)parent).getChilds().indexOf(child);
        }
        return res;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    public class Controllers {
        private List<ControllerG> childs;

        public Controllers(List<ControllerG> childs) {
            this.childs = childs;
        }

        public List<ControllerG> getChilds() {
            return this.childs;
        }

        public String toString() {
            return "Controllers";
        }
    }

    public class References {
        private List<ReferenceG> childs;

        public References(List<ReferenceG> childs) {
            this.childs = childs;
        }

        public List<ReferenceG> getChilds() {
            return this.childs;
        }

        public String toString() {
            return "References";
        }
    }

    public class Services {
        private List<ServiceG> childs;

        public Services(List<ServiceG> childs) {
            this.childs = childs;
        }

        public List<ServiceG> getChilds() {
            return this.childs;
        }

        public String toString() {
            return "Services";
        }
    }

    public class Components {
        private List<ComponentG> childs;

        public Components(List<ComponentG> childs) {
            this.childs = childs;
        }

        public List<ComponentG> getChilds() {
            return this.childs;
        }

        public String toString() {
            return "Child components";
        }
    }
}

