/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easycommons.explorer;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.petalslink.easycommons.explorer.ComponentG;
import com.petalslink.easycommons.explorer.ControllerG;
import com.petalslink.easycommons.explorer.ReferenceG;
import com.petalslink.easycommons.explorer.ServiceG;
import com.petalslink.easycommons.explorer.TreeComponentModel;
import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TreeComponentCellRenderer
extends DefaultTreeCellRenderer {
    private static final ImageIcon emptyComponentIcon = TreeComponentCellRenderer.createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/explorer/empty-composite.png"));
    private static final ImageIcon compositeIcon = TreeComponentCellRenderer.createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/explorer/composite.png"));
    private static final ImageIcon primitifIcon = TreeComponentCellRenderer.createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/explorer/primitive.png"));
    private static final ImageIcon serviceIcon = TreeComponentCellRenderer.createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/explorer/service.png"));
    private static final ImageIcon referenceIcon = TreeComponentCellRenderer.createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/explorer/reference.png"));
    private static final ImageIcon controllerIcon = TreeComponentCellRenderer.createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/explorer/controller.png"));
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        try {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof ComponentG) {
                ComponentG comp = (ComponentG)value;
                if (comp.getUnderComponents().size() == 0) {
                    this.setIcon(primitifIcon);
                    this.setToolTipText("This is a primitive component.");
                } else {
                    this.setIcon(compositeIcon);
                    this.setToolTipText("This is a composite component.");
                }
                if (SCAHelper.getSCAHelper().isStarted(comp.getModel())) {
                    this.setForeground(Color.blue);
                } else {
                    this.setForeground(Color.red);
                }
            } else if (value instanceof TreeComponentModel.Components) {
                this.setText(value.toString());
                this.setIcon(emptyComponentIcon);
                this.setToolTipText("This is the list of child components.");
            } else if (value instanceof TreeComponentModel.Services) {
                this.setText(value.toString());
                this.setIcon(serviceIcon);
                this.setToolTipText("This is the list of child services.");
            } else if (value instanceof TreeComponentModel.References) {
                this.setText(value.toString());
                this.setIcon(referenceIcon);
                this.setToolTipText("This is the list of child references.");
            } else if (value instanceof TreeComponentModel.Controllers) {
                this.setText(value.toString());
                this.setIcon(controllerIcon);
                this.setToolTipText("This is the list of child controllers.");
            } else if (value instanceof ServiceG) {
                this.setText(((ServiceG)value).getName());
                this.setIcon(serviceIcon);
                this.setToolTipText("This is a service.");
            } else if (value instanceof ReferenceG) {
                this.setText(((ReferenceG)value).getName());
                this.setIcon(referenceIcon);
                this.setToolTipText("This is a reference.");
            } else if (value instanceof ControllerG) {
                this.setText(((ControllerG)value).getName());
                this.setIcon(controllerIcon);
                this.setToolTipText("This is a controller.");
            } else {
                this.setText(value.toString());
            }
        }
        catch (SCAException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Explorer component Interrupted", 0);
        }
        return this;
    }

    private static ImageIcon createImageIcon(URL imgURL) {
        ImageIcon img = new ImageIcon(imgURL);
        return img;
    }
}

