package com.petalslink.easycommons.explorer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

/**
 * The Ball class creates 5 balls.  Each ball increasingly blends
 * the color white with the specified color.
 */
public class CornerG {

	public static int DEFAULT_SIZE = ExplorerView.SPACE/5; 
	
	public Color color = null;
	protected Rectangle rect = null;
	private ExplorerView explorer = null;
	private ComponentG parent;
	
	
	public CornerG(ExplorerView explorer, ComponentG parent) {
        this.color = Color.pink;
        this.parent = parent;
        this.explorer = explorer;
        this.init();
    }
	
	public ComponentG getParent() {
		return parent;
	}
    
	public void update(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;

		g2.setColor(this.color);
		g2.draw(this.rect);
		g2.fill(this.rect);
		
	//	g2.drawImage(img, (int)this.circle.getCenterX() + (this.size/2), (int)this.circle.getCenterY() - this.img.getHeight(null)/2 - this.size/2, null);

		
		//g2.setColor(Color.black);
		//g2.drawString(name, (int)this.circle.getCenterX() - (this.size/2), (int)this.circle.getCenterY() + this.size);
	
    }

	protected void init() {
		this.rect = new Rectangle(0, 0, DEFAULT_SIZE, DEFAULT_SIZE);
	}

	public boolean contains(int x, int y) {
		return this.rect.contains(x, y);
	}
	
	public Rectangle getRectangle() {
		return rect;
	}

	public void setLocation(int x, int y) {
		Point pos = checkLocation(x, y);
		this.rect.x = pos.x;
		this.rect.y = pos.y;
	}

	private Point checkLocation(int x, int y) {
		Point p = new Point(x, y);
		if(x < this.explorer.getX()) {
			p.x = this.explorer.getX();
		} else if(x > this.explorer.getX() + this.explorer.getWidth() - this.rect.width) {
			p.x = this.explorer.getX() + this.explorer.getWidth() - this.rect.width;
		}
		if(y < this.explorer.getY()) {
			p.y = this.explorer.getY();
		} else if(y > this.explorer.getY() + this.explorer.getHeight() - this.rect.height) {
			p.y = this.explorer.getY() + this.explorer.getHeight() - this.rect.height;
		}

		return p;
	}

	
}
