package com.ebmwebsourcing.easycommons.soap.handler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;

public class SOAPSender {

    /**
     * The logger
     */
    private final Logger log = Logger.getLogger(SOAPSender.class.getName());

    public SOAPSender() {
    }




    public Document sendSoapRequest(Document request, String address, String soapAction)
    throws SOAPException {

        Document response = null;

        if(address == null) {
            throw new SOAPException("destination address cannot be null");
        }
        if(request == null) {
            throw new SOAPException("request message cannot be null");
        }

        // First create the connection
        SOAPConnectionFactory soapConnFactory = null;
        SOAPConnection connection = null;

        try {
            soapConnFactory = SOAPConnectionFactory
            .newInstance();
            connection = soapConnFactory.createConnection();

        } catch (UnsupportedOperationException e1) {
            throw new SOAPException(e1);
        } catch (javax.xml.soap.SOAPException e1) {
            throw new SOAPException(e1);
        }

        try {



            // Next, create the actual message
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage message = messageFactory.createMessage();

            if(soapAction != null) {
                MimeHeaders hd = message.getMimeHeaders();
                hd.addHeader("SOAPAction", soapAction);
            }

            // Create objects for the message parts
            SOAPPart soapPart = message.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            SOAPBody body = envelope.getBody();

            // Populate the Message
            StreamSource preppedMsgSrc = new StreamSource(this
                    .convertDOMSource2InputSource(new DOMSource(request))
                    .getByteStream());
            soapPart.setContent(preppedMsgSrc);

            // Save the message
            message.saveChanges();

            // Check the input
            this.log.finest("\nREQUEST:\n");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(out);
            message.writeTo(ps);
            this.log.finest(out.toString());

            // Send the message and get a reply

            // Set the destination
            String destination = address;
            this.log.finest("\ndestination = " + destination);
            // Send the message
            log.finest("XXXXXX send message: " + out.toString());
            log.finest("XXXXXX destination: " + destination);
            log.finest("XXXXXX soapAction: " + soapAction);
            log.finest("XXXXXX message: " + XMLPrettyPrinter.prettyPrint(request));

            SOAPMessage reply = connection.call(message, destination);

            if (reply != null) {
                // Create the transformer
                TransformerFactory transformerFactory = TransformerFactory
                .newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                // Extract the content of the reply
                Source sourceContent = reply.getSOAPPart().getContent();
                // Set the output for the transformation
                Writer writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                transformer.transform(sourceContent, result);

                String res = writer.toString();
                this.log.finest("\nRESPONSE:\n" + res);
                DocumentBuilderFactory builder = DocumentBuilderFactory
                .newInstance();
                builder.setNamespaceAware(true);
                response = builder.newDocumentBuilder().parse(
                        new ByteArrayInputStream(res.getBytes()));

            }


        } catch (UnsupportedOperationException e) {
            throw new SOAPException(e);
        } catch (javax.xml.soap.SOAPException e) {
            throw new SOAPException(e);
        } catch (TransformerConfigurationException e) {
            throw new SOAPException(e);
        } catch (TransformerException e) {
            throw new SOAPException(e);
        } catch (SAXException e) {
            throw new SOAPException(e);
        } catch (IOException e) {
            throw new SOAPException(e);
        } catch (ParserConfigurationException e) {
            throw new SOAPException(e);
        } finally {
            // Close the connection
            try {
                connection.close();
            } catch (javax.xml.soap.SOAPException e) {
                throw new SOAPException(e);
            }
        }
        return response;
    }

    public static Document createSOAPMessageRequest(Document msg) throws JDOMException {
        Document res = null;

        // TODO: create soap1.1 or 1.2 message

        Element env = new Element("Envelope", Namespace.getNamespace("soap-env", "http://schemas.xmlsoap.org/soap/envelope/"));
        env.addNamespaceDeclaration(Namespace.getNamespace("xsd", "http://www.w3.org/1999/XMLSchema"));
        env.addNamespaceDeclaration(Namespace.getNamespace("xsi", "http://www.w3.org/1999/XMLSchema-instance"));
        org.jdom.Document jdom = new org.jdom.Document(env);
        Element body = new Element("Body", Namespace.getNamespace("soap-env", "http://schemas.xmlsoap.org/soap/envelope/"));
        env.addContent(body);

        DOMBuilder builder = new DOMBuilder();
        org.jdom.Document jdomDocument;

        if(msg != null){
             jdomDocument = builder.build(msg);
             body.addContent(((Element)((Element)jdomDocument.getRootElement()).clone()).detach());
        }
        
        

        DOMOutputter converter = new DOMOutputter();
        //converter.setForceNamespaceAware(true);
        res = converter.output(jdom);

        return res;
    }


    private static InputSource convertDOMSource2InputSource(
            final DOMSource domSource) throws SOAPException {
        InputSource source = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(os);
            Transformer transformer = TransformerFactory.newInstance()
            .newTransformer();
            transformer.transform(domSource, streamResult);
            os.flush();
            os.close();
            InputStream is = new java.io.ByteArrayInputStream(os.toByteArray());

            StreamSource attach = new StreamSource(is);
            source = SAXSource.sourceToInputSource(attach);
        } catch (final IOException e) {
            throw new SOAPException(e);
        } catch (TransformerConfigurationException e) {
            throw new SOAPException(e);
        } catch (TransformerFactoryConfigurationError e) {
            throw new SOAPException(e);
        } catch (TransformerException e) {
            throw new SOAPException(e);
        }
        return source;
    }

}
