package com.ebmwebsourcing.easycommons.soap.handler;

import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;

public class SOAPHandler {


	public static boolean isSoapFault(Document soapEnveloppe) throws SOAPException {
		boolean res = false;
		if(soapEnveloppe != null) {
			NodeList bodies = soapEnveloppe.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
			if(bodies != null && bodies.getLength() > 0) {
				Element fault = DOMUtil.getInstance().getFirstElement((Element) bodies.item(0));
				if(fault != null && fault.getNamespaceURI() != null && fault.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")&&
						fault.getLocalName().equals("Fault")) {
					res = true;
				}
			}
		}
		return res;
	}

	public static Document createSoapFault(Document businessFault) throws SOAPException {

		// TODO: create soap 1.2 fault


		// create soap 1.1  fault
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		factory.setNamespaceAware(true);

		Document root = null;
		try {
			root = factory.newDocumentBuilder().newDocument();

			Element fault = root.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
			fault.setPrefix("soapenv");
			root.appendChild(fault);

			Element faultcode = root.createElement("faultcode");
			faultcode.setNodeValue("soapenv:Server");
			fault.appendChild(faultcode);

			Element faultstring = root.createElement("faultstring");
			faultstring.setNodeValue("Server Error");
			fault.appendChild(faultstring);

			Element detail = root.createElement("detail");
			detail.appendChild(root.importNode(businessFault.getDocumentElement().cloneNode(true), true));
			fault.appendChild(detail);
		} catch (ParserConfigurationException e) {
			throw new SOAPException(e);
		}
		return root;
	}


	public static Element getBody(Document soapRequest) {
		Element body = null;
		if(soapRequest != null) {
			NodeList bodies = soapRequest.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
			if((bodies != null)&&(bodies.getLength() == 1)) {
				body = (Element) bodies.item(0);
			}
		}
		return body;
	}

	public static Element getHeader(Document soapRequest) {
		Element header = null;
		NodeList headers = soapRequest.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
		if((headers != null)&&(headers.getLength() == 1)) {
			header = (Element) headers.item(0);
		}
		return header;
	}

	public static List<Element> getFaultDetails(Document soapFault) {
		List<Element> res = new ArrayList<Element>();
		// TODO: implement for soap 1.2 fault

		if(soapFault != null) {
			Element body = SOAPHandler.getBody(soapFault);
			NodeList details = body.getElementsByTagName("detail");
			if((details != null)&&(details.getLength() == 1)) {
				Element detail = (Element) details.item(0);
				NodeList nl = detail.getChildNodes();
				for(int i = 0; i < nl.getLength(); i++) {
					if(nl.item(i).getNodeType() == Node.ELEMENT_NODE) {
						res.add((Element) nl.item(i));
					}
				}
			}
		}
		return res;
	}
}
