/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easycommons.soap.handler;

import java.util.List;
import java.util.logging.Logger;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.Binding.BindingStyle;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPMessageGenerator.Direction;

public class SOAPAdapter  {

	private Logger log = Logger.getLogger(SOAPAdapter.class.getName());

	private final Description desc;


	public SOAPAdapter(Description desc) {
		this.desc = desc;
	}


	public Document format(Document msg, final BindingOperation bOp, Direction direction) throws SOAPException {
		Document formattedMessage = null;

		// find the binding operation
		if(bOp == null) {
			throw new SOAPException("Binding operation cannot be null!!!");
		}


		// find the mode
		if(bOp.getStyle() == BindingStyle.DOCUMENT) {
			this.log.finest("format as document");
			formattedMessage = this.formatAsDocument(msg, bOp, direction);
		} else if(bOp.getStyle() == BindingStyle.RPC) {
			this.log.finest("format as rpc");
			formattedMessage = this.formatAsRpc(msg, bOp, direction);
		}  

		return formattedMessage;
	}

	private Document formatAsRpc(Document msg, final BindingOperation bOp, final Direction direction) {
		Document formattedMessage = null;

		if(msg != null) {

			// change message name by the binding operation name
			final org.jdom.Element elmt = (org.jdom.Element) msg.getRootElement().clone();

			String operationName = bOp.inferQName().getLocalPart();
			if(Direction.RESPONSE.equals(direction)) {
				operationName = operationName + "Response";
			} 
			elmt.setName(operationName);

			if(!elmt.getNamespaceURI().equals(bOp.inferQName().getNamespaceURI())) {
				elmt.setNamespace(Namespace.getNamespace(bOp.inferQName().getNamespaceURI()));
			}
			final org.jdom.Document doc = new org.jdom.Document(elmt);
			
			formattedMessage = new Document((Element) doc.getRootElement().detach());
		} else {
			// create empty operation
			String operationName = bOp.inferQName().getLocalPart();
			if(Direction.RESPONSE.equals(direction)) {
				operationName = operationName + "Response";
			} 

			final org.jdom.Element elmt = new org.jdom.Element(operationName, bOp.inferQName().getNamespaceURI());
			final org.jdom.Document doc = new org.jdom.Document(elmt);
			formattedMessage = new Document((Element) doc.getRootElement().detach());
		}

		return formattedMessage;
	}

	private Document formatAsDocument(final Document msg, final BindingOperation bop, final Direction direction) {
		Document formattedMessage = null;

		Operation op = bop.findOperation();
		
		if(msg != null) {
			
			// get the child element
			org.jdom.Element elmt = null;
			if((msg.getRootElement().getChildren() != null) && (msg.getRootElement().getChildren().size() == 1)
					&& (op.getInput().getMessageName().getLocalPart().equals((msg.getRootElement()).getName())||
							((op.getOutput() != null) && op.getOutput().getMessageName().getLocalPart().equals((msg.getRootElement()).getName())))) {
				elmt = (org.jdom.Element) ((org.jdom.Element)msg.getRootElement().getChildren().get(0)).clone();
			} else {
				elmt = (org.jdom.Element) (msg.getRootElement()).clone();
			}

			// change root name of elmt if needed
			if(Direction.REQUEST.equals(direction)&&(op.getInput() != null)) {
				if((op.getInput().getParts() != null)&&(op.getInput().getParts()[0].getType() != null)&&(op.getInput().getParts()[0].getQName() != null)) {
					elmt.setName(op.getInput().getParts()[0].getQName().getLocalPart());
					//elmt.setNamespace(Namespace.getNamespace(op.getInput().getParts().get(0).getPartQName().getNamespaceURI()));
				}
			}

			if((elmt.getNamespaceURI() == null) || (elmt.getNamespaceURI().trim().length() == 0)) {
				String prefix = null;

				prefix = op.getParentInterface().getParentDescription().getNamespaces().get(op.inferQName().getNamespaceURI());
				if((prefix == null) || (prefix.trim().length() == 0)) {
					for(final Namespace ns: (List<Namespace>)elmt.getAdditionalNamespaces()) {
						if(ns.getURI().equals(op.inferQName().getNamespaceURI())) {
							prefix = ns.getPrefix();
							break;
						}
					}
				}

				if(prefix != null) {
					elmt.setNamespace(Namespace.getNamespace(prefix, op.inferQName().getNamespaceURI()));
				} else {
					elmt.setNamespace(Namespace.getNamespace(op.inferQName().getNamespaceURI()));
				}


			}
			if((op.getInput().getParts() != null)&&(op.getInput().getParts()[0].getType() != null)) {
				elmt.setNamespace(null);
			}

			final org.jdom.Document doc = new org.jdom.Document(elmt);
			formattedMessage = new Document((Element) doc.getRootElement().detach());
		} else {
			org.jdom.Element elmt = null;

			// create empty element
			if(Direction.REQUEST.equals(direction)) {
				if(op.getInput() != null) {
					if(op.getInput().getElement() != null) {
						elmt = new org.jdom.Element(op.getInput().getElement().inferQName().getLocalPart(), op.getInput().getElement().inferQName().getNamespaceURI());
					} else if(op.getInput().getMessageName() != null) {
						elmt = new org.jdom.Element(op.getInput().getMessageName().getLocalPart(), op.getInput().getMessageName().getNamespaceURI());
					}
				}
			} else {
				if(op.getOutput() != null) {
					if(op.getOutput().getElement() != null) {
						elmt = new org.jdom.Element(op.getOutput().getElement().inferQName().getLocalPart(), op.getOutput().getElement().inferQName().getNamespaceURI());
					} else if(op.getOutput().getMessageName() != null) {
						elmt = new org.jdom.Element(op.getOutput().getMessageName().getLocalPart(), op.getOutput().getMessageName().getNamespaceURI());
					}
				}
			}

			if(elmt != null) {
				final org.jdom.Document doc = new org.jdom.Document(elmt);
				formattedMessage = new Document((Element) doc.getRootElement().detach());
			}
		}
		return formattedMessage;
	}

}
