/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.ws.bus;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import org.jdom.JDOMException;
import org.w3c.dom.Document;

public class BusThread
extends Thread {
    private String address;
    private static int delay;
    private static final SOAPSender sender;
    private Document notif;
    private boolean stop = false;

    static {
        sender = new SOAPSender();
    }

    public BusThread(String address, int delay) {
        this.address = address;
        BusThread.delay = delay;
        this.initNotif();
    }

    private void initNotif() {
        try {
            this.notif = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(Thread.currentThread().getContextClassLoader().getResource("notify.xml").openStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setDelay(int d) {
        delay = d;
    }

    @Override
    public void run() {
        try {
            while (!this.stop) {
                System.out.println("Sending notification to " + this.address + "\n" + XMLPrettyPrinter.prettyPrint((Document)this.notif));
                sender.sendSoapRequest(SOAPSender.createSOAPMessageRequest((Document)this.notif), this.address, null);
                Thread.sleep(delay * 1000);
            }
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
    }

    public void stopThread() {
        this.stop = true;
    }
}

