/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.component.bpel.impl;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELComponent;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELComponentBehaviour;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELProviderEndpoint;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELProviderEndpointBehaviour;
import com.ebmwebsourcing.easyesb.component.bpel.impl.BPELProviderEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.component.bpel.impl.BPELProviderEndpointImpl;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.behaviour.proxy.SoapProviderProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.BusinessServiceImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessContextDefinitionImpl;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import easyesb.petalslink.com.component.bpel._1_0.BpelComponentExceptionMsg;
import easyesb.petalslink.com.component.bpel.data._1.ObjectFactory;
import easyesb.petalslink.com.component.bpel.data._1.StoreBpel;
import easyesb.petalslink.com.component.bpel.data._1.StoreBpelResponse;
import easyesb.petalslink.com.component.bpel.data._1.UnstoreBpel;
import easyesb.petalslink.com.component.bpel.data._1.UnstoreBpelResponse;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Import;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Role;

public class BPELComponentBehaviourImpl
extends ComponentBehaviourImpl
implements BPELComponentBehaviour {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(BPELComponentBehaviourImpl.class.getName());
    private static Binding b;

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("wsdl/bpel-component10.wsdl");
            Description desc = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasyESBFramework.getInstance()).get()).readDocument(url, Definitions.class));
            b = (Binding)desc.getBindings().iterator().next();
        }
        catch (XmlObjectReadException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public BPELComponentBehaviourImpl(Component<? extends ComponentType> ep) {
        super(ep);
        this.setBinding(b);
    }

    public void execute(Exchange exchange) throws TransportException {
        try {
            if (exchange.getMessageIn().getBody().getPayload() == null) {
                throw new TransportException("the message in cannot be null");
            }
            DOMBuilder builder = new DOMBuilder();
            Document doc = builder.build(exchange.getMessageIn().getBody().getPayload());
            if (doc.getRootElement() != null && doc.getRootElement().getName().equals("storeBpel")) {
                log.finest("Store Bpel");
                StoreBpel storeBpelRequest = (StoreBpel)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), StoreBpel.class);
                List<String> eps = this.storeBpel(storeBpelRequest.getBpelUrl());
                StoreBpelResponse storeBpelResponse = new StoreBpelResponse();
                for (String ep : eps) {
                    storeBpelResponse.getBpelEndpointAddress().add(ep);
                }
                org.w3c.dom.Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)storeBpelResponse);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (doc.getRootElement() != null && doc.getRootElement().getName().equals("unstoreBpel")) {
                log.finest("UnStore Bpel");
                UnstoreBpel unstoreBpelRequest = (UnstoreBpel)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), UnstoreBpel.class);
                UnstoreBpelResponse storeBpelResponse = this.unstoreBpel(unstoreBpelRequest);
                org.w3c.dom.Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)storeBpelResponse);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            }
        }
        catch (BpelComponentExceptionMsg e) {
            try {
                org.w3c.dom.Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)e.getFaultInfo());
                org.w3c.dom.Document fault = SOAPHandler.createSoapFault((org.w3c.dom.Document)docEx);
                MessageUtil.getInstance().createErrorMessageStructure(exchange);
                exchange.getMessageError().getBody().setPayload(fault);
                log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)exchange.getMessageError().getBody().getPayload()));
            }
            catch (SOAException ex) {
                throw new TransportException((Throwable)ex);
            }
            catch (SOAPException ex) {
                throw new TransportException((Throwable)ex);
            }
        }
        catch (SOAException e) {
            throw new TransportException((Throwable)e);
        }
    }

    @Override
    public List<ProviderEndpointType> store(URL bpelurl) throws ESBException {
        ArrayList<ProviderEndpointType> res = new ArrayList<ProviderEndpointType>();
        try {
            log.finest("store method");
            BPELComponent bpelComponent = (BPELComponent)this.getEndpoint();
            Core core = bpelComponent.getCore();
            BPELProcess definition = (BPELProcess)core.getModel().getRegistry().storeProcessDefinition(bpelurl.toURI(), (ProcessContextDefinition)new ProcessContextDefinitionImpl());
            ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
            for (Interface itf : definition.getProcessInterfaces()) {
                for (Endpoint ep : definition.getImports().findEndpointsImplementingInterface(itf)) {
                    if (this.endpointNotExist(ep, endpoints)) continue;
                    endpoints.add(ep);
                }
            }
            for (Endpoint endpoint : endpoints) {
                Service service = this.createService(endpoint.getService().getQName(), BusinessServiceImpl.class);
                EndpointInitialContext context = (EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
                context.setNumberOfThreads(5);
                BPELProviderEndpoint providerEndpoint = (BPELProviderEndpoint)((ServiceBehaviour)service.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint(endpoint.getName(), BPELProviderEndpointImpl.class, context);
                providerEndpoint.setCore(core);
                providerEndpoint.addBehaviourClass(BPELProviderEndpointBehaviourImpl.class);
                BPELProviderEndpointBehaviour bpelProviderEndpointBehaviour = (BPELProviderEndpointBehaviour)providerEndpoint.findBehaviour(BPELProviderEndpointBehaviour.class);
                bpelProviderEndpointBehaviour.setBinding(endpoint.getBinding());
                providerEndpoint.refreshDescription();
                providerEndpoint.setWSDLDescriptionAddress(this.createURIFromLocation(bpelurl, this.findLocationFromEndpoint(endpoint, definition)));
                bpelProviderEndpointBehaviour.setCore(core);
                res.add((ProviderEndpointType)providerEndpoint.getModel());
            }
            ArrayList<Endpoint> partnerEndpoints = new ArrayList<Endpoint>();
            for (PartnerLink pl : definition.getPartnerLinks()) {
                Interface itf;
                Role role;
                PartnerLinkType plt;
                if (pl.getPartnerRole() == null || pl.getPartnerRole().trim().length() <= 0 || pl.getPartnerLinkType() == null || (plt = definition.getImports().getPartnerLinkType(pl.getPartnerLinkType())) == null || (role = plt.getRole(pl.getPartnerRole())) == null || (itf = role.findInterface(role.getInterfaceQName())) == null) continue;
                for (Endpoint ep : definition.getImports().findEndpointsImplementingInterface(itf)) {
                    if (partnerEndpoints.contains(ep)) continue;
                    partnerEndpoints.add(ep);
                }
            }
            RegistryEndpoint registryEndpoint = this.getEndpoint().getNode().getRegistryEndpoint();
            if (registryEndpoint == null) {
                throw new ESBException("Impossible to find registry... Impossible to store bpel: " + bpelurl);
            }
            for (Endpoint endpoint : partnerEndpoints) {
                if (((RegistryEndpointBehaviour)registryEndpoint.findBehaviour(RegistryEndpointBehaviour.class)).getEndpoint(new QName(endpoint.getService().getQName().getNamespaceURI(), endpoint.getName())) != null) continue;
                Service service = ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).createService(endpoint.getService().getQName(), BusinessServiceImpl.class);
                EndpointInitialContext context = (EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
                context.setNumberOfThreads(5);
                ProviderProxyEndpoint providerEndpoint = (ProviderProxyEndpoint)((ServiceBehaviour)service.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint(endpoint.getName(), ProviderProxyEndpointImpl.class, context);
                providerEndpoint.addBehaviourClass(SoapProviderProxyBehaviourImpl.class);
                System.out.println("9999999999999999999999999999999999999999999 endpoint.getAddress() = " + endpoint.getAddress());
                providerEndpoint.setExternalAddress(endpoint.getAddress());
                providerEndpoint.setWSDLDescriptionAddress(this.createURIFromLocation(bpelurl, this.findLocationFromEndpoint(endpoint, definition)));
                log.finest("*************** create partner: " + providerEndpoint.getName());
            }
        }
        catch (CoreException e) {
            log.severe("ERROR e : " + e.getMessage());
            e.printStackTrace();
            throw new ESBException((Throwable)e);
        }
        catch (URISyntaxException e) {
            log.severe("ERROR e : " + e.getMessage());
            e.printStackTrace();
            throw new ESBException((Throwable)e);
        }
        catch (Exception e) {
            log.severe("ERROR +e : " + e.getMessage());
            e.printStackTrace();
            throw new ESBException((Throwable)e);
        }
        return res;
    }

    private URI createURIFromLocation(URL bpelurl, URI location) {
        URI res = null;
        String path = bpelurl.toString().substring(0, bpelurl.toString().lastIndexOf("/") + 1);
        res = URI.create(String.valueOf(path) + location.toString());
        return res;
    }

    private URI findLocationFromEndpoint(Endpoint ep, BPELProcess def) {
        URI res = null;
        Description desc = ep.getService().getDescription();
        if (def != null) {
            for (com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import impt : def.getImports().getBPELImports()) {
                if (!impt.getNamespace().toString().equals(desc.getTargetNamespace())) continue;
                res = impt.getLocation();
                break;
            }
        }
        if (res == null) {
            block1: for (com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import impt : def.getImports().getBPELImports()) {
                if (impt.getDescription() == null) continue;
                Description d = impt.getDescription();
                for (Import wsdlImpt : d.getImports()) {
                    if (impt.getNamespace().equals(desc.getTargetNamespace())) {
                        res = impt.getLocation();
                        continue block1;
                    }
                    if (res != null) continue;
                    res = this.findLocationFromEndpoint(ep, impt.getDescription());
                }
            }
        }
        return res;
    }

    private URI findLocationFromEndpoint(Endpoint ep, Description parentDescription) {
        URI res = null;
        Description desc = ep.getService().getDescription();
        for (Import impt : parentDescription.getImports()) {
            if (impt.getNamespace().equals(desc.getTargetNamespace())) {
                res = URI.create(impt.getLocation());
                break;
            }
            if (res != null) continue;
            res = this.findLocationFromEndpoint(ep, impt.getParentDescription());
        }
        return res;
    }

    private boolean endpointNotExist(Endpoint ep, List<Endpoint> endpoints) {
        boolean res = false;
        for (Endpoint tmp : endpoints) {
            if (!tmp.getName().equals(ep.getName()) || !tmp.getService().getQName().getNamespaceURI().equals(ep.getService().getQName().getNamespaceURI()) || !tmp.getService().getQName().getLocalPart().equals(ep.getService().getQName().getLocalPart())) continue;
            res = true;
            break;
        }
        return res;
    }

    @Override
    public List<ProviderEndpointType> unstore(URL bpel) throws ESBException {
        throw new ESBException("NotImplememented");
    }

    public UnstoreBpelResponse unstoreBpel(UnstoreBpel parameters) throws BpelComponentExceptionMsg {
        UnstoreBpelResponse res = new UnstoreBpelResponse();
        try {
            List<ProviderEndpointType> eps = this.unstore(URI.create(parameters.getBpelUrl()).toURL());
            for (ProviderEndpointType ep : eps) {
                res.getBpelEndpointAddress().add(ep.getService() + "::" + ep.getName());
            }
        }
        catch (MalformedURLException e) {
            throw new BpelComponentExceptionMsg("StoreBpel operation error", (Throwable)e);
        }
        catch (ESBException e) {
            throw new BpelComponentExceptionMsg("StoreBpel operation error", (Throwable)e);
        }
        return res;
    }

    public List<String> storeBpel(String bpelUrl) throws BpelComponentExceptionMsg {
        ArrayList<String> res = null;
        try {
            List<ProviderEndpointType> eps = this.store(URI.create(bpelUrl).toURL());
            res = new ArrayList<String>();
            for (ProviderEndpointType ep : eps) {
                res.add(ep.getService() + "::" + ep.getName());
            }
        }
        catch (MalformedURLException e) {
            throw new BpelComponentExceptionMsg("StoreBpel operation error", (Throwable)e);
        }
        catch (ESBException e) {
            throw new BpelComponentExceptionMsg("StoreBpel operation error", (Throwable)e);
        }
        return res;
    }
}

